;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SQ (QUESTIONS) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20  ; 8 bit Accumulator, 16 bit X/Y
	REP #$10 

	wai

	stz Joy1Press
	stz Joy1Press+1  ;;reset input buttons  
	stz Joy1New
	stz Joy1New+1

	wai

	jsr LoadLast

	ClearLine 9					; \ temporarily hide firmware version strings
	ClearLine 10					; /
	ClearLine 11
	ClearLine 12
	ClearLine 13
	ClearLine 14
	ClearLine 15
	ClearLine 16
	ClearLine 21					; \ temporarily hide button assignment hints
	ClearLine 22					; /

	SetCursorPos 11, 0
	PrintString "The game you've played features battery-backed SRAM\n"
	PrintString "to save your progress. Please choose an option:"

	SetCursorPos 14, 1

	lda saveName.sCluster
	bne AutoSaveMenu
	lda saveName.sCluster+1
	bne AutoSaveMenu
	lda saveName.sCluster+2
	bne AutoSaveMenu
	lda saveName.sCluster+3
	bne AutoSaveMenu

	PrintString "(No SRAM file loaded previously, auto-saving disabled)"
	lda #$A0
	sta cursorY
	jmp AutoSaveMenuDone

AutoSaveMenu:  
	lda #$88					; cursor line = (cursorY - $18) / $08 (in this case, $0E=14)
	sta cursorY
	PrintString "Save SRAM to the previously loaded file:"

	SetCursorPos 15, 1
	lda #<saveName
	sta strPtr
	lda #>saveName
	sta strPtr+1
	ldy #strPtr
	PrintString "%s"

AutoSaveMenuDone:

	SetCursorPos 17, 1
	PrintString "Select a file ..."

	SetCursorPos 18, 1
	PrintString "Cancel and discard SRAM!"
	lda #$0D
	sta cursorX
 	SetCursorPos 21,0



ForeverSQ:
	wai

StartCheck:
	lda Joy1New+1
	and #%00010000
	beq StartCheckDone

	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'I'
	sta findEntry+1
	jump jCardLoadModule			; START = cancel, load intro module

StartCheckDone:

NorthCheck:
	lda Joy1New+1
	and #%00001000
	beq NorthCheckDone
	jsr PrevButton				; up pressed

NorthCheckDone:

SouthCheck:
	lda Joy1New+1
	and #%00000100
	beq SouthCheckDone
	jsr NextButton				; down pressed

SouthCheckDone:

ABXYCheck:
	lda Joy1New+1
	and #%11000000
	bne ABXYNextModule
	lda Joy1New
	and #%11110000
	bne ABXYNextModule			; ABXYlr = select game
	jmp ABXYCheckDone

ABXYNextModule:
	jsr ChooseButton

ABXYCheckDone:

	jmp ForeverSQ



NextButton:					; $88 -> $A0 -> $A8
	lda cursorY
	clc
	adc #$08
	sta cursorY
	cmp #$B0
	bne NextButtonDone
	lda #$88
	sta cursorY
	bra NextButtonDone2

NextButtonDone:
	lda cursorY
	cmp #$90
	bne NextButtonDone2
	lda #$A0
	sta cursorY

NextButtonDone2:

rts



PrevButton:					; $A8 -> $A0 -> $88
	lda cursorY
	sec
	sbc #$08
	sta cursorY
	cmp #$80
	bne PrevButtonDone
	lda #$A8
	sta cursorY
	bra PrevButtonDone2

PrevButtonDone:
	lda cursorY
	cmp #$98
	bne PrevButtonDone2
	lda #$88
	sta cursorY

PrevButtonDone2:

rts



ChooseButton:
	lda cursorY				; if auto save
	cmp #$88
	beq AutoSave

	lda cursorY				; if yes, go to SB.MAP to display .srm files
	cmp #$A0
	beq NextModuleSB

	lda cursorY				; if no, go to SI.MAP to display intro
	cmp #$A8
	bne ChooseButtonDone
	lda #$01
	sta CONFIGWRITESTATUS			; turn off the battery info
	jmp NextModuleSI

ChooseButtonDone:

rts



AutoSave:
	lda saveName.sCluster
	bne AutoSaveContinue
	lda saveName.sCluster+1
	bne AutoSaveContinue
	lda saveName.sCluster+2
	bne AutoSaveContinue
	lda saveName.sCluster+3
	bne AutoSaveContinue
rts

AutoSaveContinue:
	jsr SaveFile
-
	lda Joy1New+1				; wait for user input
	and #%11111111
	bne +
	lda Joy1New+0
	and #%11110000
	bne +
	bra -
+

NextModuleSI:
	lda #$FF
	sta SpriteBuf1+17			; move title graphics off screen
	sta SpriteBuf1+21
	sta SpriteBuf1+25
	sta SpriteBuf1+29
	sta SpriteBuf2+1			; 32x32 sprites

	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'I'
	sta findEntry+1
	wai
	jump jPrintClearScreen
	jump jLoadLogo
	jump jLoadRomVersion
	jump jCardLoadModule			; load intro module

NextModuleSB:
	lda #$FF
	sta SpriteBuf1+17			; move title graphics off screen
	sta SpriteBuf1+21
	sta SpriteBuf1+25
	sta SpriteBuf1+29
	sta SpriteBuf2+1			; 32x32 sprites

	lda #'I'
	sta nextModule				; go to intro when done
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'B'
	sta findEntry+1
	jump jCardLoadModule			; go to filebrowser



LoadLast:					; load LASTSNES.TXT file
	lda #'T'
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'X'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'T'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda baseDirCluster			; "POWERPAK" dir start
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jClearFindEntry			; find LASTSNES.TXT in "POWERPAK" dir
	lda #'L'
	sta findEntry
	lda #'A'
	sta findEntry+1
	lda #'S'
	sta findEntry+2
	lda #'T'
	sta findEntry+3
	lda #'S'
	sta findEntry+4
	lda #'N'
	sta findEntry+5
	lda #'E'
	sta findEntry+6
	lda #'S'
	sta findEntry+7

	jump jCardLoadDir			; "POWERPAK" dir

	jump jDirFindEntry			; get first cluster
	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put into sector RAM
	stz destBank
	stz sectorCounter
	stz bankCounter
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; sector -> WRAM

	ldx #$0000
	ldy #$0000

LoadLastGameLoop:				; game name and cluster
	lda sectorBuffer1, y
	sta gameName, x
	iny
	inx
	cpx #$80				; 128 bytes
	bne LoadLastGameLoop

	ldx #$0000

LoadLastSaveLoop:				; save name and cluster
	lda sectorBuffer1, y
	sta saveName, x
	iny
	inx
	cpx #$80				; 128 bytes
	bne LoadLastSaveLoop

rts



SaveFile:
	lda #$FF
	sta cursorX
	lda #$F0
	sta cursorY

	ClearLine 17
	ClearLine 18

	lda #%00000001
	sta CONFIGWRITESTATUS			; no more battery flag

	lda saveName.sCluster
	sta sourceCluster
	lda saveName.sCluster+1
	sta sourceCluster+1
	lda saveName.sCluster+2
	sta sourceCluster+2
	lda saveName.sCluster+3			; copy save cluster
	sta sourceCluster+3			; to source cluster

	lda #$00
	sta DMAWRITELO
	sta DMAWRITEHI
	lda #$F8
	sta DMAWRITEBANK

	SetCursorPos 17, 0
	PrintString "Saving SRAM file ..."

	lda #kSourceSDRAM
	sta sourceType

	jump jCardWriteFile

	SetCursorPos 17, 0
	PrintString "SRAM file saved successfully!"

	SetCursorPos 18, 0
	PrintString "Press any button to return to the titlescreen."
rts
