;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SO (OPTIONS SCREEN) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20				; 8 bit Accumulator, 16 bit X/Y
	REP #$10

	stz Joy1Press
	stz Joy1Press+1				; reset input buttons  
	stz Joy1New
	stz Joy1New+1


	lda #$D5
	sta DMAWRITELO
	lda #$FF
	sta DMAWRITEHI
	lda #$40
	sta DMAWRITEBANK			; destroy header $40FFC0
	lda #$00
	sta $21FF

	lda #$D5
	sta DMAWRITELO
	lda #$FF
	sta DMAWRITEHI
	lda #$00
	sta DMAWRITEBANK			; destroy header $FFC0
	lda #$00
	sta $21FF

	lda #$D5
	sta DMAWRITELO
	lda #$7F
	sta DMAWRITEHI
	lda #$00
	sta DMAWRITEBANK			; destroy header $7FC0
	lda #$00
	sta $21FF

;  lda #%00000011  ;battused, bootmode
;  sta CONFIGWRITESTATUS

	wai
	jump jPrintClearScreen

; ****** V2.00 DEBUG STUFF *********************
;	SetCursorPos 22, 1
;	PrintHexNum selectedEntry+1
;	PrintString "-"
;	PrintHexNum selectedEntry
;	PrintString "  "
;	PrintHexNum sourceEntryHi
;	PrintString "-"
;	PrintHexNum sourceEntryLo
;	PrintString "  "
;	PrintHexNum destEntryHi
;	PrintString "-"
;	PrintHexNum destEntryLo
;	PrintString "  "
;	PrintHexNum destBank
;	PrintString "-"
;	PrintHexNum destHi
;	PrintString "-"
;	PrintHexNum destLo
;	PrintString "  "
;	PrintHexNum sourceBank
;	PrintString "-"
;	PrintHexNum sourceHi
;	PrintString "-"
;	PrintHexNum sourceLo
;	PrintString "  "
;	PrintHexNum tempEntry.tempCluster+3
;	PrintString "-"
;	PrintHexNum tempEntry.tempCluster+2
;	PrintString "-"
;	PrintHexNum tempEntry.tempCluster+1
;	PrintString "-"
;	PrintHexNum tempEntry.tempCluster
;	PrintString "  "
;	PrintHexNum sourceCluster+3
;	PrintString "-"
;	PrintHexNum sourceCluster+2
;	PrintString "-"
;	PrintHexNum sourceCluster+1
;	PrintString "-"
;	PrintHexNum sourceCluster+0
;	PrintString "  "
;	PrintHexNum baseDirCluster+3
;	PrintString "-"
;	PrintHexNum baseDirCluster+2
;	PrintString "-"
;	PrintHexNum baseDirCluster+1
;	PrintString "-"
;	PrintHexNum baseDirCluster
;	PrintString "  "
;	PrintString " codeBufHi:"
;	PrintHexNum >codeBuffer
;	PrintString "   codeBufLo:"
;	PrintHexNum <codeBuffer
; ****** END DEBUG *****************************

	SetCursorPos 3, 6
	PrintString "Load battery-backed SRAM ..."
	SetCursorPos 4, 1

	lda #<saveName
	sta strPtr
	lda #>saveName
	sta strPtr+1
	ldy #strPtr
	PrintString "%s"

	SetCursorPos 7, 6
	PrintString "Add/edit GameGenie codes ..."
	SetCursorPos 9, 7			; prints saved or previously entered codes (!)
	ldy #$0000
	jump jGameGeniePrint
	SetCursorPos 11, 7
	ldy #$0008
	jump jGameGeniePrint
	SetCursorPos 13, 7
	ldy #$0010
	jump jGameGeniePrint
	SetCursorPos 15, 7
	ldy #$0018
	jump jGameGeniePrint
	SetCursorPos 17, 7
	ldy #$0020
	jump jGameGeniePrint

	SetCursorPos 20, 6
	PrintString "Play!"
	SetCursorPos 21, 1
	lda #<gameName
	sta strPtr
	lda #>gameName
	sta strPtr+1
	ldy #strPtr
	PrintString "%s"

	lda #$B8
	sta cursorY
	lda #$38
	sta cursorX
	lda #$00
	sta cursorYCounter
	sta cursorYUp
	sta cursorYDown
	sta scrollY
	sta scrollYCounter     
	sta scrollYUp          
	sta scrollYDown     

	stz Joy1Press
	stz Joy1Press+1
	stz Joy1New
	stz Joy1New+1
 


ForeverSO:
	wai
	jsr ReadController
	jmp ForeverSO



LoadGameModule:
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'M'
	sta findEntry+1    
	jump jCardLoadModule			; load mapper module



LoadGGLabelModule:
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'G'
	sta findEntry+1    
	jump jCardLoadModule			; load GameGenie module



NextButton:
	lda cursorY
	cmp #$30
	bne NextCheckStart
;  jsr LoadBRAMModule   ;load battery ram

LoadBRAMModule:
	lda #'O'
	sta nextModule				; go back to options after picking SRAM file
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'B'
	sta findEntry+1
	jump jCardLoadModule
;  rts

NextCheckStart:
	lda cursorY
	cmp #$B8
	bne NextCheckGGLabel
	jmp LoadGameModule			; start game
;  rts

NextCheckGGLabel:
	lda cursorY
	cmp #$50
	bne NextCheckGameGenie
	jmp LoadGGLabelModule			; load GameGenie code TXT file

NextCheckGameGenie:
	lda cursorY
	cmp #$60
	beq NextCheckGameGenieNext		; GameGenie
	cmp #$70
	beq NextCheckGameGenieNext
	cmp #$80
	beq NextCheckGameGenieNext
	cmp #$90
	beq NextCheckGameGenieNext
	cmp #$A0
	beq NextCheckGameGenieNext
	jmp NextCheckDone

NextCheckGameGenieNext:  
	jump jGameGenieNextChar
;  jsr GameGenieNextChar
rts

NextCheckDone:

rts


PrevButton:
	lda cursorY
	cmp #$30
	bne PrevCheckStart
	jmp LoadBRAMModule			; load battery ram
;  rts

PrevCheckStart:
	lda cursorY
	cmp #$B8
	bne PrevCheckGGLabel
	jmp LoadGameModule			; start game
;  rts

PrevCheckGGLabel:
	lda cursorY
	cmp #$50
	bne PrevCheckGameGenie
	jmp LoadGGLabelModule			; load GameGenie code TXT file

PrevCheckGameGenie
	lda cursorY
	cmp #$60
	beq PrevCheckGameGeniePrev		; GameGenie
	cmp #$70
	beq PrevCheckGameGeniePrev
	cmp #$80
	beq PrevCheckGameGeniePrev
	cmp #$90
	beq PrevCheckGameGeniePrev
	cmp #$A0
	beq PrevCheckGameGeniePrev
	jmp PrevCheckDone

PrevCheckGameGeniePrev:
	jump jGameGeniePrevChar
 ; jsr GameGeniePrevChar
rts

PrevCheckDone:

rts



ReadController:

AXCheck:					; fixed (was A, B instead), R added
;	lda Joy1New+1
;	and #%10000000
;	bne AXNext
	lda Joy1New
	and #%11010000				; A, X, R
	bne AXNext
	jmp AXCheckDone
AXNext:
	jsr NextButton
;  jmp CheckDone

AXCheckDone:

BYCheck:					; fixed (was X, Y instead), L added
	lda Joy1New+1
	and #%11000000				; B, Y
	bne BYPrev
	lda Joy1New
	and #%00100000				; L
	bne BYPrev
	jmp BYCheckDone

BYPrev:
	jsr PrevButton
;  jmp CheckDone

BYCheckDone:

SelectCheck:
	lda Joy1Press+1
	and #%00100000
	beq SelectCheckUp			; if Select is released, clear decoded GG code lines

SelectCheckDown:
	jsr SelectButton
	jmp SelectCheckDone

SelectCheckUp:
	ClearLine 10
	ClearLine 12
	ClearLine 14
	ClearLine 16
	ClearLine 18

SelectCheckDone:

StartCheck:
	lda Joy1New+1
	and #%00010000
	beq StartCheckDone

	lda #%10000001
	sta CONFIGWRITESTATUS			; reset PowerPak, stay in boot mode, necessary because

;	jump jClearFindEntry			; reloading intro for ~36 times crashed the PowerPak in v1.0X
;	lda #'S'
;	sta findEntry
;	lda #'I'
;	sta findEntry+1
;	wai
;	jump jPrintClearScreen
;	jump jLoadLogo
;	jump jLoadRomVersion
;	jump jCardLoadModule      ;START = cancel, load intro module

StartCheckDone:

NorthCheck:					; handle up button, cursorY = cursorY-16
	lda Joy1New+1
	and #%00001000
	bne NorthStart
	jmp SouthCheck

;;if at start game (B8)
;;  go to game genie 5 (A0)
;;if at game genie 5 (A0)
;;  go to game genie 4 (90)
;;if at game genie 4 (90)
;;  go to game genie 3 (80)
;;if at game genie 3 (80)
;;  go to game genie 2 (70)
;;if at game genie 2 (70)
;; go to game genie 1 (60)
;;if at game genie 1 (60)
;; go to game genie label(50)
;;if at game genie label (50)
;; go to load bram (30)
;;if at bram (30)
;; go to start game (B8)

NorthStart:
	lda cursorY
	cmp #$B8
	bne NorthGG5
	lda #$A0
	sta cursorY
	jmp NorthIndent

NorthGG5:
	lda cursorY
	cmp #$A0
	bne NorthGG4
	lda #$90
	sta cursorY
	jmp NorthIndent

NorthGG4:
	lda cursorY
	cmp #$90
	bne NorthGG3
	lda #$80
	sta cursorY
	jmp NorthIndent

NorthGG3:
	lda cursorY
	cmp #$80
	bne NorthGG2
	lda #$70
	sta cursorY
	jmp NorthIndent

NorthGG2:
	lda cursorY
	cmp #$70
	bne NorthGG1
	lda #$60
	sta cursorY
	jmp NorthIndent

NorthGG1:
	lda cursorY
	cmp #$60
	bne NorthGGLabel
	lda #$50
	sta cursorY
	jmp NorthIndent

NorthGGLabel:
	lda cursorY
	cmp #$50
	bne NorthBram
	lda #$30
	sta cursorY
	jmp NorthIndent

NorthBram:
	lda #$B8
	sta cursorY

NorthIndent:
	lda cursorY
	cmp #$28
	bne CheckIndent
	lda #$A8
	sta cursorY

	jmp CheckDone				; if at start+2, set to load



CheckIndent:
	jsr AtIndent				; if at gamegenie or arcade, cursorX = start
	lda temp
	cmp #$01
	bne DoNoIntent
	jsr AtIndent				; if at 0s or underscores, cursorX = start + 8
	lda temp
	cmp #$01
	beq DoIntent
	jmp CheckDone

DoNoIntent:
	lda #$38
	sta cursorX
	jmp CheckDone

DoIntent:
	lda #$40
	sta cursorX
	jmp CheckDone


SouthCheck:					; handle down button
	lda Joy1New+1
	and #%00000100
	beq WestCheck

;;if at start game (B8)
;; go to load bram (30)
;;if at game genie 5 (A0)
;; go to start game (B8)
;;if at game genie 4 (90)
;; go to game genie 5 (A0)
;;if at game genie 3 (80)
;; go to game genie 4 (90)
;;if at game genie 2 (70)
;;  go to game genie 3 (80)
;;if at game genie 1 (60)
;;  go to game genie 2 (70)
;;if at bram (30)

;; go to game genie label (50)

;;if at gglabel (50)
;; go to game genie 1 (60)

SouthStart:
	lda cursorY
	cmp #$B8
	bne SouthGG5
	lda #$30
	sta cursorY
	jmp SouthIndent

SouthGG5:
	lda cursorY
	cmp #$A0
	bne SouthGG4
	lda #$B8
	sta cursorY
	jmp SouthIndent

SouthGG4:
	lda cursorY
	cmp #$90
	bne SouthGG3
	lda #$A0
	sta cursorY
	jmp SouthIndent

SouthGG3:
	lda cursorY
	cmp #$80
	bne SouthGG2
	lda #$90
	sta cursorY
	jmp SouthIndent

SouthGG2:
	lda cursorY
	cmp #$70
	bne SouthGG1
	lda #$80
	sta cursorY
	jmp SouthIndent

SouthGG1:
	lda cursorY
	cmp #$60
	bne SouthBram
	lda #$70
	sta cursorY
	jmp SouthIndent

SouthBram:
	lda cursorY
	cmp #$30
	bne SouthGGLabel
	lda #$50
	sta cursorY
	jmp SouthIndent

SouthGGLabel:
	lda #$60
	sta cursorY

SouthIndent:
	cmp #$C0
	beq SouthIndentChange
	jmp CheckIndent				; if not below start, check for indent change

SouthIndentChange:
	lda #$30
	sta cursorY

	jmp CheckDone				; if at start+2, set to load    

WestCheck:					; handle left button
	lda Joy1New+1
	and #%00000010
	beq EastCheck

	jsr AtIndent
	lda temp
	cmp #$01
	beq MoveCursorWest
	jmp CheckDone  

MoveCursorWest:    
	lda cursorX
	cmp #$40				; and not at start
	beq CheckDone
	sec
	lda cursorX
	sbc #$10
	sta cursorX				; cursorX = cursorX-16
	jmp CheckDone

EastCheck:					; handle right button
	lda Joy1New+1
	and #%00000001
	beq CheckDone

	jsr AtIndent
	lda temp
	cmp #$01
	beq MoveCursorEast
	jmp CheckDone  

MoveCursorEast:
	lda cursorX
	cmp #$B0				; and not at end
	beq CheckDone
	clc
	lda cursorX
	adc #$10
	sta cursorX				; cursorX = cursorX+16
	jmp CheckDone

CheckDone:

rts



AtIndent:
	lda #$00
	sta temp
	lda cursorY
	cmp #$60
	beq AtIndentYes				; if at underscores or 0s
	cmp #$70
	beq AtIndentYes
	cmp #$80
	beq AtIndentYes
	cmp #$90
	beq AtIndentYes
	cmp #$A0
	beq AtIndentYes
rts

AtIndentYes:
	lda #$01
	sta temp
rts



SelectButton:					; print decoded GG codes
	SetCursorPos 10, 8
	ldy #$0000
	jump jGameGenieDecode
	SetCursorPos 12, 8
	ldy #$0008
	jump jGameGenieDecode
	SetCursorPos 14, 8
	ldy #$0010
	jump jGameGenieDecode
	SetCursorPos 16, 8
	ldy #$0018
	jump jGameGenieDecode
	SetCursorPos 18, 8
	ldy #$0020
	jump jGameGenieDecode
rts
