;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SN (ROM BROWSER & LOADER) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20				; 8 bit Accumulator, 16 bit X/Y
	REP #$10

	stz Joy1Press
	stz Joy1Press+1				; reset input buttons
	stz Joy1New
	stz Joy1New+1

	lda #'S'				; SMC, SWC, SFC files
	sta ex5Match1
	sta ex5Match1+1
	sta ex5Match1+2
	lda #'M'
	sta ex5Match2
	lda #'W'
	sta ex5Match2+1
	lda #'F'
	sta ex5Match2+2
	lda #'C'
	sta ex5Match3
	sta ex5Match3+1
	sta ex5Match3+2

	lda #'G'				; GD3 files
	sta ex5Match1+3
	lda #'D'
	sta ex5Match2+3
	lda #'3'
	sta ex5Match3+3

	lda #'S'				; SPC files
	sta ex5Match1+4
	lda #'P'
	sta ex5Match2+4
	lda #'C'
	sta ex5Match3+4

	lda rootDirCluster
	sta sourceCluster
	lda rootDirCluster+1
	sta sourceCluster+1
	lda rootDirCluster+2
	sta sourceCluster+2
	lda rootDirCluster+3
	sta sourceCluster+3



MainLoad:  
	jump jPrintClearScreen
	SetCursorPos 0 0			; probably irrelevant (see DirPrintDir in loader.asm)
	jsr CardLoadDir				; first dir
	jump jDirPrintDir

	stz Joy1New
	stz Joy1New+1				; reset input buttons  
	stz Joy1Press
	stz Joy1Press+1



Forever:
	wai

;  SetCursorPos 10 10
;  PrintHexNum cursorY



UpCheck:
	lda Joy1New+1
	and #%00001000
	beq UpDone

UpPressed:
	lda cursorYCounter
	bne UpDone
	lda scrollYCounter
	bne UpDone

UpScroll:
	lda #$08
	sta speedScroll
	lda #$01
	sta speedCounter
	jump jScrollUp

UpDone:



DownCheck:
	lda Joy1New+1
	and #%00000100
	beq DownDone

DownPressed:
	lda cursorYCounter
	bne DownDone
	lda scrollYCounter
	bne DownDone

DownScroll:
	lda #$08
	sta speedScroll
	lda #$01
	sta speedCounter
	jump jScrollDown

DownDone:



LeftCheck:
	lda Joy1Press+1
	and #%00000010
	beq LeftDone

LeftPressed:
	lda cursorYCounter
	bne LeftDone
	lda scrollYCounter
	bne LeftDone

LeftScroll:
	lda #$04
	sta speedScroll
	lda #$02
	sta speedCounter
	jump jScrollUp

LeftDone:



RightCheck:
	lda Joy1Press+1
	and #%00000001
	beq RightDone

RightPressed:
	lda cursorYCounter
	bne RightDone
	lda scrollYCounter
	bne RightDone

RightScroll:
	lda #$04
	sta speedScroll
	lda #$02
	sta speedCounter
	jump jScrollDown

RightDone:



LCheck:
	lda Joy1New
	and #%00100000
	beq LDone

;	jump jPageUp
	jsr PageUp

LDone:



RCheck:
	lda Joy1New
	and #%00010000
	beq RDone

;	jump jPageDown
	jsr PageDown

RDone:



ABXYCheck:
	lda Joy1New+1
	and #%11000000
	bne ABXYNextModule
	lda Joy1New
	and #%11000000
	bne ABXYNextModule			; ABXY = select game
	jmp ABXYCheckDone

ABXYNextModule:
	jsr NextModule

ABXYCheckDone:



StartCheck:
	lda Joy1New+1
	and #%00010000
	beq StartDone
	jsr LoadLast				; Start pressed, load last game info
	jmp NextModuleSOLast

StartDone: 



;----------------------- removed 2.0 (PowerPak crashes!) -----------------------
; Removed the whole Select checking code because CardVerifyFile seems broken,
; and who needs a verify feature anyway? ;-)
;
;SelectCheck:        ;;SELECT = verify loaded file
;	lda Joy1New+1
;	and #%00100000
;	beq SelectDone
;
;	jump jDirGetEntry       ;get selected entry
;	lda tempEntry.tempCluster
;	sta sourceCluster 
;	lda tempEntry.tempCluster+1
;	sta sourceCluster+1
;	lda tempEntry.tempCluster+2
;	sta sourceCluster+2
;	lda tempEntry.tempCluster+3
;	sta sourceCluster+3      ;copy to source cluster
;
;	lda #$00
;	sta DMAWRITELO
;	lda #$FE
;	sta DMAWRITEHI
;	lda #$FF
;	sta DMAWRITEBANK   ;;read file so dma wraps, erasing header
;
;	stz sectorCounter
;	stz bankCounter
;  jsr CardVerifyFile				; this crashed the PowerPak!
;
;SelectDone:
;-------------------------------------------------------------------------------

	jmp Forever



NextModule:
	jump jDirGetEntry			; get selected entry

	lda tempEntry.tempDirFlag
	cmp #$01  
	bne NextModuleLoad
	jsr NextDir
rts



NextModuleLoad:
	ldy #$00				; FIXME2.0 ?? should be ldy #$0000 ??

CopyGameNameLoop:				; this affects the START GAME screen / SO.MAP
	lda tempEntry, y
	sta gameName, y
	iny
	cpy #$35				; copy 53 chars
	bne CopyGameNameLoop

	stz gameName+$35			; NULL terminate game name

	lda tempEntry.tempCluster
	sta gameName.gCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta gameName.gCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta gameName.gCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta gameName.gCluster+3			; copy to game cluster
	sta sourceCluster+3			; copy to source cluster

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put first sector into sector RAM
	stz destBank
	stz sectorCounter
	stz bankCounter
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; sector -> WRAM

	lda sectorBuffer1+$05
	cmp #'S'				; check for SPC
	bne NextModuleSO
	lda sectorBuffer1+$06
	cmp #'P'
	bne NextModuleSO
	lda sectorBuffer1+$07
	cmp #'C'
	bne NextModuleSO
	jmp NextModuleSP			; SPC found, go to player



NextModuleSO:
	lda #$FF				; temporarily put the cursor off-screen
	sta cursorX
	lda #$F0
	sta cursorY
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'A'
	sta findEntry+1
	jump jCardLoadModule			; load auto save loading module

; Removed for v2.00 due to crashing bug
;NextModuleSI:
;  jump jClearFindEntry
;  lda #'S'
;  sta findEntry
;  lda #'I'
;  sta findEntry+1
;  wai
;  jump jPrintClearScreen
;  jump jLoadLogo
;  jump jLoadRomVersion
;  jump jCardLoadModule      ;return to options or save module



NextModuleSP:
	lda #$FF				; hide cursor
	sta cursorX
	lda #$F0
	sta cursorY
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	lda #$00
	sta nextModule				; make sure not to leave SPC player again
	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda #'P'
	sta findEntry+1
	jump jCardLoadModule			; load SPC player module



NextModuleSOLast:				; only invoked by pressing Start in the filebrowser
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	jump jClearFindEntry
	lda #'O'
	sta findEntry+1
	lda #'S'
	sta findEntry
	jump jCardLoadModule			; load module



; ********************** Page-by-page navigation ***********************

PageDown:
	lda filesInDir+1
	cmp #$00
	bne +
	lda filesInDir
	cmp #$19
	bcs +					; if filesInDir < 25, do nothing
rts

+
	rep #A_8BIT				; A = 16 bit

	lda filesInDir
	sec
	sbc selectedEntry
	cmp #$0031
	bcs +					; if filesInDir-selectedEntry<49, show "last page"
	lda filesInDir				; by means of: selectedEntry=filesInDir-24
	sec
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

	bra ShowNextPage

+
	sep #A_8BIT				; A = 8 bit

	lda cursorY
	sec
	sbc #$18				; subtract indention
	lsr a
	lsr a
	lsr a					; divide by 8 to get selectedEntry difference
	sta temp

	lda selectedEntry
	sec
	sbc temp				; subtract selectedEntry diff. to keep cursor in sync

	rep #A_8BIT				; A = 16 bit

	lda selectedEntry
	clc
	adc #$0018				; add 24 for "next page"
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

ShowNextPage:
	lda #$02				; Y indention
	sta temp

	jump jPrintClearScreen
	SetCursorPos 0, 0

PageDownPrintLoop:				; with these new parameters, print next page
	inc temp				; go to next print line
	jump jDirPrintEntry

 ; jsr DirPrintEntry                            ;copy dir entry to printString
 ; jsr PrintLine                                ;print to name table

	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; increment to next entry index
	adc #$00
	sta selectedEntry+1

	lda temp				; check if printY equal to 26, jump out
	cmp #$1A
	beq PageDownPrintLoopDone

;	lda selectedEntry			; check if temp/temp+1 equal to filesInDir, jump out
;	cmp filesInDir
;	bne PageDownPrintLoop
;	lda selectedEntry+1
;	cmp filesInDir+1
;	bne PageDownPrintLoop

;	lda #$00				; beyond filesInDir, show beginning of directory again
;	sta selectedEntry
;	sta selectedEntry+1

	bra PageDownPrintLoop

PageDownPrintLoopDone:
	rep #A_8BIT

	lda selectedEntry			; since we used the same variable for printing,
	sec					; we must subtract the added 24 lines again
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT

	lda #$18				; #$08 = line 0, #$10 = line 1, etc.
	sta cursorY            
	stz cursorYCounter      
	stz cursorYUp          
	stz cursorYDown          

	stz scrollY            
	stz scrollYCounter      
	stz scrollYUp           
	stz scrollYDown   

	stz speedCounter        
	stz speedScroll         

	lda #$01
	sta insertTop
	lda #$1A
	sta insertBottom

NoPageDown:

rts



PageUp:
	lda filesInDir+1
	cmp #$00
	bne +
	lda filesInDir
	cmp #$19
	bcs +					; if filesInDir < 25, do nothing
rts

+
	lda selectedEntry+1
	cmp #$00
	bne +
	lda selectedEntry
	cmp #$18
	bcs +					; if selectedEntry<=24, show "first page"
	lda #$00
	sta selectedEntry
	sta selectedEntry+1
	bra ShowPrevPage

+
	lda cursorY
	sec
	sbc #$18				; subtract indention
	lsr a
	lsr a
	lsr a					; divide by 8 to get selectedEntry difference
	sta temp

	lda selectedEntry
	sec
	sbc temp				; subtract selectedEntry diff. to keep cursor in sync

	rep #A_8BIT				; A = 16 bit

	lda selectedEntry
	sec
	sbc #$0018				; subtract 24 for "previous page"
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

ShowPrevPage:
	lda #$02				; Y indention
	sta temp

	jump jPrintClearScreen
	SetCursorPos 0, 0

PageUpPrintLoop:				; with these new parameters, print next page
	inc temp				; go to next print line
	jump jDirPrintEntry

 ; jsr DirPrintEntry                            ;copy dir entry to printString
 ; jsr PrintLine                                ;print to name table

	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; increment to next entry index
	adc #$00
	sta selectedEntry+1

	lda temp				; check if printY equal to 26, jump out
	cmp #$1A
	beq PageUpPrintLoopDone

;	lda selectedEntry			; check if temp/temp+1 equal to filesInDir, jump out
;	cmp filesInDir
;	bne PageUpPrintLoop
;	lda selectedEntry+1
;	cmp filesInDir+1
;	bne PageUpPrintLoop

;	lda #$00				; beyond filesInDir, show beginning of directory again
;	sta selectedEntry
;	sta selectedEntry+1

	bra PageUpPrintLoop

PageUpPrintLoopDone:
	rep #A_8BIT

	lda selectedEntry			; since we used the same variable for printing,
	sec					; we must subtract the added 24 lines again
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT

	lda #$18				; #$08 = line 0, #$10 = line 1, etc.
	sta cursorY            
	stz cursorYCounter      
	stz cursorYUp          
	stz cursorYDown          

	stz scrollY            
	stz scrollYCounter      
	stz scrollYUp           
	stz scrollYDown   

	stz speedCounter        
	stz speedScroll         

	lda #$01
	sta insertTop
	lda #$1A
	sta insertBottom

NoPageUp:

rts



;----------------------- removed 2.0 (PowerPak crashes!) -----------------------
; Removed the whole broken CardVerifyFile routine, too
;
;CardVerifyFile:					; sourceCluster already set  
;	wai
;	ClearLine 20
;	ClearLine 21
;	ClearLine 22
;	SetCursorPos 20, 1
;	PrintString "Verifying File\n"
;
;	lda #$00
;	sta bankCounter
;	sta bankOffset
;	sta bankOffset+1
;
;	lda #$00
;	sta DMAWRITEBANK
;	sta DMAWRITELO
;	sta DMAWRITEHI
;
;	lda #$00
;	sta gameSize
;	sta gameSize+1
;	jump jClusterToLBA            ;sourceCluster -> first sourceSector
;
;CardVerifyFileLoop:
;	clc
;	lda gameSize
;	adc #$01
;	sta gameSize
;	lda gameSize+1
;	adc #$00
;	sta gameSize+1            ;;keep track of game size
;
;
;	jsr CardVerifySector
;
;	lda destHi
;	pha
;	lda destLo
;	pha
;	jump jLoadNextSectorNum
;	pla 
;	sta destLo
;	pla 
;	sta destHi
;
;CardVerifyFileLastSectorCheck:  
;	lda #$0F
;	sta temp
;	lda #$FF
;	sta temp+1                            ;;FAT32 last cluster = 0x0FFFFFFF
;	sta temp+2
;	sta temp+3
;
;	lda fat32Enabled
;	cmp #$01
;	beq CardVerifyFileLastSectorCheck2        ;;if FAT32, last cluster mask done
;
;	lda #$00
;	sta temp
;	sta temp+1                             ;;FAT16 last cluster = 0x0000FFFF
;
;CardVerifyFileLastSectorCheck2:
;check if cluster = last cluster
; if match, jmp to last entry found
;	lda temp
;	cmp sourceCluster+3
;	bne CardVerifyFileNextSector
;	lda temp+1
;	cmp sourceCluster+2
;	bne CardVerifyFileNextSector
;	lda temp+2
;	cmp sourceCluster+1
;	bne CardVerifyFileNextSector
;	lda temp+3
;	cmp sourceCluster+0
;	bne CardVerifyFileNextSector
;	jmp CardVerifyFileDone
;
;CardVerifyFileNextSector:
;	inc destHi
;	inc destHi
;  inc bankCounter
;  lda bankCounter
;  cmp #$00                 ;;only load 256x512=128KB for modules
;  beq CardVerifyFileDone
;
;
;	jmp CardVerifyFileLoop
;
;CardVerifyFileDone:
;	PrintString "Verify Passed"
;rts
;
;
;
;CardVerifySector:
;PrintHexNum bankCounter
;	PrintString "jCardWaitNotBusy\n"
;	jump jCardWaitNotBusy
;PrintHexNum bankCounter
;	PrintString "jCardWaitReady\n"
;	jump jCardWaitReady
;PrintHexNum bankCounter
;	PrintString "jCardCheckError\n"
;	jump jCardCheckError
;PrintHexNum bankCounter
;	PrintString "jCardLoadLBA\n"
;	jump jCardLoadLBA
;
;	lda #$00
;	sta sourceBytes16
;	lda #$02
;	sta sourceBytes16+1
;
;  PrintHexNum bankCounter
;	PrintString "jCardWaitNotBusy\n"
;	jump jCardWaitNotBusy
;  PrintHexNum bankCounter
;	PrintString "jCardWaitReady\n"
;	jump jCardWaitReady
;  PrintHexNum bankCounter
;	PrintString "jCardCheckError\n"
;	jump jCardCheckError
;
;	lda #$20
;	sta CARDCOMMAND           ;send card read sector command
;	nop
;	nop
 ; jump jCardWaitNotBusy
 ; jump jCardWaitReady
;  PrintHexNum bankCounter
;	PrintString "jCardCheckError\n"
;	jump jCardCheckError
;  PrintHexNum bankCounter
;	PrintString "jCardWaitDataReq\n"
;	jump jCardWaitDataReq
;
;	jsr CardVerifyBytesToSDRAM
;
;CardVerifySectorCheckDone:
;  PrintHexNum bankCounter
;	PrintString "jCardCheckError\n"
;	jump jCardCheckError
;CardVerifySectorDone:
;rts  
;
;
;
;
;CardVerifyBytesToSDRAM:         ;use DMA, no increment source or dest
;	ldx sourceBytes16
;CardVerifyBytesToSDRAMLoop:
;	lda $21FF
;	sta errorCode
;	lda CARDDATAREAD  ;;READ DATA BYTE
;	sta errorCode+1
;	cmp errorCode
;	bne CardVerifyBytesToSDRAMLoopError
;
;CardVerifyBytesToSDRAMLoopNext:
;	lda bankOffset
;	clc
;	adc #$01
;	sta bankOffset
;	lda bankOffset+1
;	adc #$00
;	sta bankOffset+1
;	lda bankCounter
;	adc #$00
;	sta bankCounter
;
;	dex
;	bne CardVerifyBytesToSDRAMLoop
;rts
;
;CardVerifyBytesToSDRAMLoopError:
;	phx
;	SetCursorPos 21, 0
;	PrintString "Verify Error\n wanted $"
;	PrintHexNum errorCode+1
;	PrintString " read $"
;	PrintHexNum errorCode
;	PrintString " @$"
;	PrintHexNum bankCounter
;	PrintHexNum bankOffset+1
;	PrintHexNum bankOffset
;	PrintString "\n"
;CardVerifyError:
;  wai
;  jmp CardVerifyError
;	plx
;	jmp CardVerifyBytesToSDRAMLoopNext
;-------------------------------------------------------------------------------



; **************** CF loading routines (see LOADER.ASM) ****************

;dest = sector dest  0200
;sourceEntry = where to get entry in 0200-0400, when overflow, load next sector
;destBank =  which bank to select in prg ram
;destEntry = where to put entry in prg ram 6000-7FFF, when overflow, increment bank

CardLoadDir:  
	lda #>sectorBuffer1
	sta destHi				; sourceSector1 = where to put sector, where to read entry
	sta sourceEntryHi
	lda #<sectorBuffer1
	sta destLo
	sta sourceEntryLo
	stz destBank
	stz sourceEntryBank

	stz destEntryHi
	stz destEntryLo
	lda #$7F
	sta destEntryBank			; $7F0000 - where to put entry

	stz filesInDir
	stz filesInDir+1
	stz sectorCounter
	stz temp
	stz temp+1
	stz selectedEntry
	stz selectedEntry+1
	stz lfnFound

	jump jClusterToLBA			; sourceCluster -> first sourceSector

	lda fat32Enabled
	cmp #$01
	beq CardLoadDirReadSector		; FAT32 go to read sector

	lda sourceCluster			; FAT16 check if trying to load root dir
	cmp rootDirCluster
	bne CardLoadDirReadSector
	lda sourceCluster+1
	cmp rootDirCluster+1
	bne CardLoadDirReadSector
	lda sourceCluster+2
	cmp rootDirCluster+2
	bne CardLoadDirReadSector 
	lda sourceCluster+3
	cmp rootDirCluster+3
	bne CardLoadDirReadSector  

	sec
	lda clusterBeginLBA
; FAT16 sourceSector = root dir first sector =>  clusterLBABegin(4) - fat16RootSectors(1)
	sbc fat16RootSectors
	sta sourceSector
	lda clusterBeginLBA+1
	sbc #$00
	sta sourceSector+1
	lda clusterBeginLBA+2
	sbc #$00
	sta sourceSector+2  
	lda clusterBeginLBA+3
	sbc #$00
	sta sourceSector+3

CardLoadDirReadSector:  
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; put into dest
	jump jCardLoadDirClearEntryName		; clear entry name

CardLoadDirLoop:
	ldy #$0000
	lda [sourceEntryLo], y			; if name[0] = 0x00, no more entries
	cmp #$00
	beq CardLoadDirLastEntryFound
	jmp CardLoadDirCheckUnused

CardLoadDirLastEntryFound:

rts



CardLoadDirCheckUnused:
	ldy #$0000
	lda [sourceEntryLo], y
	cmp #$E5				; if name[0] = 0xE5, entry unused, skip
	bne CardLoadDirCheckLongName
	lda #$00
	sta lfnFound
	jmp CardLoadDirNextEntry

CardLoadDirCheckLongName:
	ldy #$000B
	lda [sourceEntryLo], y			; if flag = %00001111, long file name entry found
	and #$0F
	cmp #$0F
	bne +

	ldy #$0000				; check first byte of LFN entry = ordinal field
	lda [sourceEntryLo], y
	and #%10111111				; mask off "last entry" bit
	cmp #$01				; if index = 1...8, load name
	beq CardLoadDirLongName1
	cmp #$02
	beq CardLoadDirLongName2
	cmp #$03
	beq CardLoadDirLongName3
	cmp #$04
	beq CardLoadDirLongName4
	cmp #$05
	beq CardLoadDirLongName5
	cmp #$06
	beq CardLoadDirLongName6
	cmp #$07
	beq CardLoadDirLongName7
	cmp #$08
	beq CardLoadDirLongName8

	jump jCardLoadDirClearEntryName		; else skip entry

	jmp CardLoadDirNextEntry

+
	jmp CardLoadDirCheckShortName



;//CHANGE ME  USE MULTIPLY13 FUNCTION

CardLoadDirLongName1:
	ldx #$0000				; index 1 = chars 0-12
	jmp CardLoadDirLongName

CardLoadDirLongName2:
	ldx #$000D				; index 2 = chars 13-25
	jmp CardLoadDirLongName

CardLoadDirLongName3:
	ldx #$001A				; index 3 = chars 26-38
	jmp CardLoadDirLongName

CardLoadDirLongName4:
	ldx #$0027				; index 4 = chars 39-51
	jmp CardLoadDirLongName

CardLoadDirLongName5:
	ldx #$0034				; index 5 = chars 52-64
	jmp CardLoadDirLongName

CardLoadDirLongName6:
	ldx #$0041				; index 6 = chars 65-77
	jmp CardLoadDirLongName

CardLoadDirLongName7:
	ldx #$004E				; index 7 = chars 78-90
	jmp CardLoadDirLongName

CardLoadDirLongName8:
	ldx #$005B				; index 8 = chars 91-103
	jmp CardLoadDirLongName



CardLoadDirLongName:
	lda #$00
	sta tempEntry.tempCounter
	ldy #$0001

CardLoadDirLongNameLoop1:
	lda [sourceEntryLo], y			; loop thro 5 chars   1x3x5x7x9x
	cmp #$FF
	beq CardLoadDirLongNameLoop1FF
	sta tempEntry, x

CardLoadDirLongNameLoop1FF:
	inx
	iny
	iny
	inc tempEntry.tempCounter
	lda tempEntry.tempCounter
	cmp #$05
	bne CardLoadDirLongNameLoop1

	ldy #$000E

CardLoadDirLongNameLoop2:
	lda [sourceEntryLo], y			; loop thro 6 chars   Ex10x12x14x16x18x
	cmp #$FF
	beq CardLoadDirLongNameLoop2FF  
	sta tempEntry, x

CardLoadDirLongNameLoop2FF:
	inx
	iny
	iny
	inc tempEntry.tempCounter
	lda tempEntry.tempCounter
	cmp #$0B
	bne CardLoadDirLongNameLoop2

	ldy #$001C

CardLoadDirLongNameLoop3:
	lda [sourceEntryLo], y			; thro 2 chars   1Cx1Ex
	cmp #$FF
	beq CardLoadDirLongNameLoop3FF  
	sta tempEntry, x

CardLoadDirLongNameLoop3FF:
	inx
	iny
	iny
	lda [sourceEntryLo], y
	cmp #$FF
	beq CardLoadDirLongNameLoop4FF  
	sta tempEntry, x

CardLoadDirLongNameLoop4FF:
	lda #$01
	sta lfnFound
	jmp CardLoadDirNextEntry

CardLoadDirCheckShortName:
	ldy #$000B
	lda [sourceEntryLo], y			; if flag = volume id, skip
	and #$08
	cmp #$08
	bne CardLoadDirCheckHidden
	jump jCardLoadDirClearEntryName
	lda #$00
	sta lfnFound
	jmp CardLoadDirNextEntry



CardLoadDirCheckHidden:
	ldy #$000B
	lda [sourceEntryLo], y
	and #$02
	cmp #$02				; if flag = 0x02, hidden, skip
	bne CardLoadDirCheckDir
	lda #$00
	sta lfnFound
	jump jCardLoadDirClearEntryName		; clear entry name  
	jmp CardLoadDirNextEntry

CardLoadDirCheckDir:
	ldy #$000B
	lda [sourceEntryLo], y			; if flag = directory, load entry
	and #$10
	cmp #$10
	bne CardLoadDirCheckEx1
	lda #$01
	sta tempEntry.tempDirFlag
	jmp CardLoadDirShortName

CardLoadDirCheckEx1:
	ldx #$0000
	ldy #$0008

CardLoadDirCheckEx1Loop:
	lda [sourceEntryLo], y
	cmp ex5Match1, x
	beq CardLoadDirCheckEx2
	inx
	cpx #$0005
	bne CardLoadDirCheckEx1Loop
	lda #$00
	sta lfnFound
	jump jCardLoadDirClearEntryName    
	jmp CardLoadDirNextEntry		; if extension doesn't match, skip

CardLoadDirCheckEx2:
	ldx #$0000
	ldy #$0009

CardLoadDirCheckEx2Loop:
	lda [sourceEntryLo], y
	cmp ex5Match2, x
	beq CardLoadDirCheckEx3
	inx
	cpx #$0005
	bne CardLoadDirCheckEx2Loop
	lda #$00
	sta lfnFound
	jump jCardLoadDirClearEntryName
	jmp CardLoadDirNextEntry		; if extension doesn't match, skip

CardLoadDirCheckEx3:
	ldx #$0000
	ldy #$000A

CardLoadDirCheckEx3Loop:
	lda [sourceEntryLo], y
	cmp ex5Match3, x
	beq CardLoadDirShortName
	inx
	cpx #$0005
	bne CardLoadDirCheckEx3Loop
	lda #$00
	sta lfnFound
	jump jCardLoadDirClearEntryName
	jmp CardLoadDirNextEntry		; if extension doesn't match, skip

CardLoadDirShortName:
	clc  
	lda filesInDir				; filesInDir++
	adc #$01
	sta filesInDir
	lda filesInDir+1
	adc #$00
	sta filesInDir+1
	
	lda lfnFound
	cmp #$01
	beq CardLoadDirLongShortNameFound

CardLoadDirShortNameFound:  
	ldy #$0000

CardLoadDirShortNameLoop:			; if lfnFound = 0, copy short name
	lda [sourceEntryLo], y
	sta tempEntry, y
	iny
	cpy #$0008
	bne CardLoadDirShortNameLoop

CardLoadDirShortFileName:  
	lda tempEntry.tempDirFlag
	cmp #$01
	beq CardLoadDirSaveEntry

	lda #'.'
	sta tempEntry+$8
	ldy #$0008
	lda [sourceEntryLo], y			; copy short file name
	sta tempEntry+$9
	iny
	lda [sourceEntryLo], y
	sta tempEntry+$A
	iny
	lda [sourceEntryLo], y
	sta tempEntry+$B  

	jmp CardLoadDirSaveEntry



CardLoadDirLongShortNameFound:    

CardLoadDirSaveEntry:
	ldy #$001A
	lda [sourceEntryLo], y			; copy clusterhilo to last 4 bytes of entry
	sta tempEntry.tempCluster
	iny
	lda [sourceEntryLo], y
	sta tempEntry.tempCluster+1
	ldy #$0014
	lda [sourceEntryLo], y
	sta tempEntry.tempCluster+2
	iny
	lda [sourceEntryLo], y
	sta tempEntry.tempCluster+3

	ldy #$0000

CardLoadDirSaveEntryLoop:			; copy entry to prg ram
	lda tempEntry, y
	sta [destEntryLo], y                
	iny
	cpy #$0080
	bne CardLoadDirSaveEntryLoop

	clc
	lda destEntryLo				; destEntry += 128
	adc #$80
	sta destEntryLo
	lda destEntryHi
	adc #$00
	sta destEntryHi

;  lda destEntryHi                        ;check if destEntry is overflowing, inc bank, destEntry=6000
;  cmp #$80
;  bne CardLoadDirClearTempEntryName
;  lda #$60
;  sta destEntryHi                        ;reset to $6000
;  lda #$00
;  sta destEntryLo
;  inc destBank                           ;increment bank num

	jump jCardLoadDirClearEntryName

;CardLoadDirClearTempEntryName:
;  ldy #$0000
;  lda #$00  
;  sta lfnFound  
;CardLoadDirClearTempEntryLoop:            ;clear entry name
;  sta tempEntry, y
;  iny
;  cpy #$0020
;  bne CardLoadDirClearTempEntryLoop



CardLoadDirNextEntry:
	clc					; increment entry source address
	lda sourceEntryLo			; sourceEntry += 32 in 0200-0400
	adc #$20
	sta sourceEntryLo
	lda sourceEntryHi
	adc #$00
	sta sourceEntryHi  

	lda sourceEntryHi			; if source overflows, get next sector
	cmp #>sectorBuffer1+$02			; LAST CHANGE
	beq CardLoadDirNextSector

	jmp CardLoadDirLoop



CardLoadDirNextSector:    
	clc
	lda sourceSector  
	adc #$01
	sta sourceSector			; go to next sector num
	lda sourceSector+1
	adc #$00
	sta sourceSector+1
	lda sourceSector+2
	adc #$00
	sta sourceSector+2
	lda sourceSector+3
	adc #$00
	sta sourceSector+3

	lda fat32Enabled			; if FAT32, goto CardLoadDirSectorInc
	cmp #$01
	beq CardLoadDirSectorInc

	lda sourceCluster			; FAT16 check if trying to load root dir
	cmp rootDirCluster
	bne CardLoadDirSectorInc
	lda sourceCluster+1
	cmp rootDirCluster+1
	bne CardLoadDirSectorInc
	lda sourceCluster+2
	cmp rootDirCluster+2
	bne CardLoadDirSectorInc 
	lda sourceCluster+3
	cmp rootDirCluster+3
	bne CardLoadDirSectorInc  

	clc
	lda sectorCounter			; FAT16 root dir all sequential sectors
	adc #$01
	sta sectorCounter

	clc
	lda sectorCounter
	cmp fat16RootSectors			; if sectorCounter = fat16RootSectors
	beq CardLoadDirLastEntryFoundJmp	; goto CardLoadDirLastEntryFound
	jmp CardLoadDirLoadNextSector		; FAT16 skip cluster lookup when max root sectors not reached

CardLoadDirLastEntryFoundJmp:
	jmp CardLoadDirLastEntryFound		; FAT16 max root sectors reached, all root entries found

CardLoadDirSectorInc:
	clc
	lda sectorCounter			; one more sector
	adc #$01
	sta sectorCounter
	cmp sectorsPerCluster			; make sure cluster isn't overflowing      
	bne CardLoadDirLoadNextSector

	jump jNextCluster			; move to next cluster

CardLoadDirLastEntryCheck:  
	lda #$0F
	sta temp
	lda #$FF
	sta temp+1				; FAT32 last cluster = 0x0FFFFFFF
	sta temp+2
	sta temp+3

	lda fat32Enabled
	cmp #$01
	beq CardLoadDirLastEntryCheck2		; if FAT32, last cluster mask done

	lda #$00				; FAT16 last cluster = 0x0000FFFF
	sta temp
	sta temp+1

CardLoadDirLastEntryCheck2:			; if cluster = last cluster, jmp to last entry found
	lda temp
	cmp sourceCluster+3
	bne CardLoadDirNextSectorNum
	lda temp+1
	cmp sourceCluster+2
	bne CardLoadDirNextSectorNum
	lda temp+2
	cmp sourceCluster+1
	bne CardLoadDirNextSectorNum
	lda temp+3
	cmp sourceCluster+0
	bne CardLoadDirNextSectorNum

	jmp CardLoadDirLastEntryFound


CardLoadDirNextSectorNum:
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #$00
	sta sectorCounter			; reset sector counter

CardLoadDirLoadNextSector:
	lda #<sectorBuffer1
	sta destLo				; reset sector dest
	sta sourceEntryLo			; reset entry source
	lda #>sectorBuffer1                   
	sta destHi
	sta sourceEntryHi
	stz destBank
	stz sourceEntryBank
	lda #kDestWRAM
	sta destType
	jump jCardReadSector
	jmp CardLoadDirLoop



NextDir:
	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3			; load dir selected

	lda sourceCluster
	cmp #$00
	bne LoadNextDir
	lda sourceCluster+1			; check if cluster = root dir
	cmp #$00
	bne LoadNextDir
	lda sourceCluster+2
	cmp #$00
	bne LoadNextDir
	lda sourceCluster+3
	cmp #$00
	bne LoadNextDir

	lda rootDirCluster
	sta sourceCluster
	lda rootDirCluster+1
	sta sourceCluster+1
	lda rootDirCluster+2
	sta sourceCluster+2
	lda rootDirCluster+3
	sta sourceCluster+3



LoadNextDir:  
	lda #$FF				; hide cursor
	sta cursorX
	lda #$F0
	sta cursorY
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	SetCursorPos 0, 0
	jsr CardLoadDir
	jump jDirPrintDir
rts



; ************************** Reload last game **************************

LoadLast:					; invoked by pressing Start in the filebrowser
	;;load LAST.TXT file
	lda #'T'
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'X'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'T'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda baseDirCluster			; "POWERPAK" dir start
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jClearFindEntry			; find LASTSNES.TXT
	lda #'L'
	sta findEntry
	lda #'A'
	sta findEntry+1
	lda #'S'
	sta findEntry+2
	lda #'T'
	sta findEntry+3
	lda #'S'
	sta findEntry+4
	lda #'N'
	sta findEntry+5
	lda #'E'
	sta findEntry+6
	lda #'S'
	sta findEntry+7

	jump jCardLoadDir			; "POWERPAK" dir

	jump jDirFindEntry			; get first cluster
	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put into sector RAM
	stz destBank
	stz sectorCounter
	stz bankCounter
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; sector -> WRAM

	ldx #$0000
	ldy #$0000

LoadLastGameLoop:				; game name and cluster
	lda sectorBuffer1, y
	sta gameName, x
	iny
	inx
	cpx #$80
	bne LoadLastGameLoop

	ldx #$0000

LoadLastSaveLoop:				; save name and cluster
	lda sectorBuffer1, y
	sta saveName, x
	iny
	inx
	cpx #$80
	bne LoadLastSaveLoop

	ldx #$0000

LoadLastGameGenieLoop:				; GameGenie chars 5x8
	lda sectorBuffer1, y
	sta gameGenie, x
	iny
	inx
	cpx #40
	bne LoadLastGameGenieLoop

rts
