;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SI (INTRO SCREEN) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20
	REP #$10
	lda #$FF
	sta cursorX
	lda #$F0
	sta cursorY

	jsr UserLogo				; check for user logo setting

	SetCursorPos 10, 5
	PrintString "      CF modules v2.00-beta1    "
	SetCursorPos 21, 5
	PrintString "ABXY: Browse CF - Start: Last game"
	SetCursorPos 22, 5
	PrintString " Sel.: Memcheck - L+R: Dev's note"
	wai
	ldy #$0000
	jump jGameGenieClear
	ldy #$0008
	jump jGameGenieClear
	ldy #$0010
	jump jGameGenieClear
	ldy #$0018
	jump jGameGenieClear
	ldy #$0020
	jump jGameGenieClear



; ************************* Clear name buffers *************************

ClearGameName:
	ldy #$0000
	lda #' '

ClearNameLoop:
	sta gameName.gName, y
	iny
	cpy #$7C
	bne ClearNameLoop
	lda #$00
	sta gameName.gCluster
	sta gameName.gCluster+1
	sta gameName.gCluster+2
	sta gameName.gCluster+3



ClearSaveName:
	ldy #$0000
	lda #' '

ClearSaveNameLoop:
	sta saveName.sName, y
	iny
	cpy #$7C
	bne ClearSaveNameLoop
	lda #$00
	sta saveName.sCluster
	sta saveName.sCluster+1
	sta saveName.sCluster+2
	sta saveName.sCluster+3



; *************************** Configure FPGA ***************************

	lda #$00
	sta CONFIGWRITEDSP			; turn off DSP chip
	stz Joy1Press
	stz Joy1Press+1				; reset input buttons
	stz Joy1New
	stz Joy1New+1

	lda CONFIGREADSTATUS			; open bus = $20

;  sta errorCode
;	SetCursorPos 14, 1
;	PrintString "FPGA status="
;  PrintHexNum errorCode
;  lda errorCode
;Wait:
;  jmp Wait

	and #$F0
	cmp #$A0
	beq fpgaISconfigured
	jmp fpgaNOTconfigured

fpgaISconfigured:
;	SetCursorPos 15, 1
;	PrintString "FPGA was configured"
	lda CONFIGREADSTATUS			; battery used = D1
	and #$02
	bne BatteryUsed
;	SetCursorPos 16, 1
;	PrintString "battery not used"
	jmp Forever

BatteryUsed:
;	SetCursorPos 16, 1
;	PrintString "battery used"
	jmp NextModuleSQ

fpgaNOTconfigured:
	jump jClearFindEntry
	lda #'T'
	sta findEntry
	lda #'O'
	sta findEntry+1
	lda #'P'
	sta findEntry+2
	lda #'L'
	sta findEntry+3
	lda #'E'
	sta findEntry+4
	lda #'V'
	sta findEntry+5
	lda #'E'
	sta findEntry+6
	lda #'L'
	sta findEntry+7

  ;lda #$FF
  ;sta $420d  ;;turn ON FASTROM

	lda #$01
	sta FPGAPROGRAMWRITE			; SEND PROGRAM SIGNAL TO FPGA
	lda #$00
	sta FPGAPROGRAMWRITE			; SEND PROGRAM SIGNAL TO FPGA
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	lda #$01
	sta FPGAPROGRAMWRITE			; SEND PROGRAM SIGNAL TO FPGA

	jump jCardLoadFPGA

  ;ClearLine 18
	;SetCursorPos 18, 1
	;PrintString "FPGA just configured\n"

	wai
	lda #%00000001
	sta CONFIGWRITESTATUS			; unlock SDRAM


;	PrintString "unlocked sdram"

	SetCursorPos 24, 0
	jsr FPGACheck
	jsr DSPCheck
	jsr SDRAMCheck



; ***************************** Intro Loop *****************************

Forever:  

ForeverLoop:
	wai

;  ClearLine 27
;	SetCursorPos 27, 1
;	PrintString "FPGA STATUS = "
;  lda CONFIGREADSTATUS
;  sta errorCode
;  PrintHexNum errorCode

	lda Joy1New+1				; check for user input  
	and #%11000000				; B, Y
	bne NextModuleSN			; go to ROM browser
	lda Joy1New+0				; check for user input
	and #%11000000				; A, X
	bne NextModuleSN			; go to ROM browser

SelectCheck:
	lda Joy1New+1				; check for Select button  
	and #%00100000
	beq SelectCheckDone
	jsr ShowConsoleVersionICheck		; Select pressed, show version numbers and run memory check
	jsr FPGACheck
	jsr DSPCheck
	jsr SDRAMCheck
	jump jMemCheck

	jmp ForeverLoop

SelectCheckDone:

StartCheck:
	lda Joy1New+1				; check for Start button  
	and #%00010000
	beq StartCheckDone
	jsr LoadLast				; Start pressed, load last game info
	jmp NextModuleSO

StartCheckDone:

LRCheck:
	lda Joy1Press				; check for L and R button
	and #%00110000
	cmp #%00110000
	bne LRCheckDone
	jmp NextModuleSD			; if both are pressed, load Developer's Note

LRCheckDone:

	jmp ForeverLoop



; ************************ Load another module *************************

NextModuleSN:
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	jump jClearFindEntry
	lda #'N'
	sta findEntry+1
	jmp NextModule

NextModuleSQ:
	jump jClearFindEntry
	lda #'Q'
	sta findEntry+1
	jmp NextModule

NextModuleSO:					; preload options module
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	jump jClearFindEntry
	lda #'O'
	sta findEntry+1
	jmp NextModule

NextModuleSD:					; Developer's Note module
	jump jPrintClearScreen
	SetCursorPos 11, 11
	PrintString "Loading ..."
	lda #'D'
	sta nextModule				; load SPC player with custom tune first

	lda #'S'
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'P'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'C'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda baseDirCluster
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jClearFindEntry			; search for SD.SPC
	lda #'S'
	sta findEntry
	lda #'D'
	sta findEntry+1

	jump jCardLoadDir			; "POWERPAK" dir

	jump jDirFindEntry			; get first cluster
	lda tempEntry.tempCluster
	sta gameName.gCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta gameName.gCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta gameName.gCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta gameName.gCluster+3			; copy to game cluster (i.e., cluster of the SPC file)
	sta sourceCluster+3			; copy to source cluster

	jump jClearFindEntry
	lda #'P'
	sta findEntry+1
	jmp NextModule

NextModule:
	lda #$FF
	sta SpriteBuf1+17			; move title graphics off screen
	sta SpriteBuf1+21
	sta SpriteBuf1+25
	sta SpriteBuf1+29
	sta SpriteBuf2+1			; 32x32 sprites
	lda #'S'
	sta findEntry
	jump jCardLoadModule			; load selected module



; ******************************* Checks *******************************

FPGACheck:
	lda #$00
	sta CONFIGWRITEDSP			; turn off DSP chip
	lda CONFIGREADSTATUS			; open bus = $20
	sta errorCode
	and #$F0
	cmp #$A0
	beq FPGACheckPass

FPGACheckFail:
	PrintString "\n    FPGA error "  
	PrintHexNum errorCode

FPGACheckFailLoop:
	jmp FPGACheckFailLoop

FPGACheckPass:

rts



SDRAMCheck:
	lda $F00000
	sta errorCode

	lda #$55
	sta $F00000
	lda $F00000
	sta errorCode+1

	lda errorCode
	sta $F00000

	lda errorCode+1
	cmp #$55

	lda #$AA
	sta $F00000
	lda $F00000
	cmp #$AA

	bne SDRAMError
	jmp SDRAMPass1

SDRAMError:
	PrintString "\n         SDRAM error " 
	lda $F00000
	sta errorCode
	PrintHexNum errorCode

SDRAMFail:
	jmp SDRAMFail

SDRAMPass1:

rts



DSPCheck:
	lda #$04
	sta CONFIGWRITEDSP			; turn on HiROM chip
	lda.l $007000				; HiROM $00:6000 = DR, $00:7000 = SR
	sta errorCode
	and #%10000000
	beq DSPBad
	jmp DSPGood

DSPBad:
	SetCursorPos 13, 1
	PrintString "DSP1: not installed"

rts

DSPGood:
	SetCursorPos 13, 1
	PrintString "DSP1: installed"

rts



ShowConsoleVersionICheck:
	lda Joy1Press+1
	and #%00100000
	bne ShowConsoleVersionI
	jmp ShowConsoleVersionIDone		; show console chipset revision

ShowConsoleVersionI:  
	lda $4210				; CPU version
	and #$0F
	sta temp
	lda $213E				; PPU1 version
	and #$0F
	sta temp+1
	lda $213F				; PPU2 version
	and #$0F
	sta temp+2

	SetCursorPos 12, 23
	PrintString "CPU:"
	PrintHexNum temp
	SetCursorPos 13, 22
	PrintString " PPU1:"
	PrintHexNum temp+1
	SetCursorPos 14, 22
	PrintString " PPU2:"
	PrintHexNum temp+2
	SetCursorPos 12, 1
	PrintString "DMA:"
	lda dontUseDMA
	bne ShowConsoleVersionIOff

ShowConsoleVersionOnI:
	PrintString " ON "
	jmp ShowConsoleVersionIDone

ShowConsoleVersionIOff:
	PrintString " OFF"

ShowConsoleVersionIDone:

rts



; ************************** Reload last game **************************

LoadLast:
	;;load LAST.TXT file
	lda #'T'
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'X'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'T'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda baseDirCluster			; "POWERPAK" dir start
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jClearFindEntry			; find LASTSNES.TXT
	lda #'L'
	sta findEntry
	lda #'A'
	sta findEntry+1
	lda #'S'
	sta findEntry+2
	lda #'T'
	sta findEntry+3
	lda #'S'
	sta findEntry+4
	lda #'N'
	sta findEntry+5
	lda #'E'
	sta findEntry+6
	lda #'S'
	sta findEntry+7

	jump jCardLoadDir			; "POWERPAK" dir

	jump jDirFindEntry			; get first cluster
	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put into sector RAM
	stz destBank
	stz sectorCounter
	stz bankCounter
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; sector -> WRAM

	ldx #$0000
	ldy #$0000

LoadLastGameLoop:				; game name and cluster
	lda sectorBuffer1, y
	sta gameName, x
	iny
	inx
	cpx #$80
	bne LoadLastGameLoop

	ldx #$0000

LoadLastSaveLoop:				; save name and cluster
	lda sectorBuffer1, y
	sta saveName, x
	iny
	inx
	cpx #$80
	bne LoadLastSaveLoop

	ldx #$0000

LoadLastGameGenieLoop:				; GameGenie chars 5x8
	lda sectorBuffer1, y
	sta gameGenie, x
	iny
	inx
	cpx #40
	bne LoadLastGameGenieLoop

rts



; ********************** Check user logo setting ***********************

UserLogo:
	lda #'T'				; load CONFIG.TXT file
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'X'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'T'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda baseDirCluster			; "POWERPAK" dir start
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jClearFindEntry
	lda #'C'
	sta findEntry+0
	lda #'O'
	sta findEntry+1
	lda #'N'
	sta findEntry+2
	lda #'F'
	sta findEntry+3
	lda #'I'
	sta findEntry+4
	lda #'G'
	sta findEntry+5

	jump jCardLoadDir			; "POWERPAK" dir

	jump jDirFindEntry			; get first cluster
	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put into sector ram
	stz destBank
	stz sectorCounter
	stz bankCounter
	jump jClusterToLBA			; sourceCluster -> first sourceSector
	lda #kDestWRAM
	sta destType
	jump jCardReadSector			; sector -> WRAM

	ldy #$0000

UserLogoConfigLoop:				; look for LOGO=1 / LOGO=2 / LOGO=3
	lda sectorBuffer1, y
	cmp #'L'
	beq UserLogoConfigLoopFound

UserLogoConfigLoopNext:
	iny 
	cpy #$FF
	beq UserLogoConfigDone
	jmp UserLogoConfigLoop

UserLogoConfigLoopFound:
	iny
	lda sectorBuffer1, y
	cmp #'O'
	bne UserLogoConfigLoopNext
	iny
	lda sectorBuffer1, y
	cmp #'G'
	bne UserLogoConfigLoopNext
	iny
	lda sectorBuffer1, y
	cmp #'O'
	bne UserLogoConfigLoopNext
	iny
	lda sectorBuffer1, y
	cmp #'='
	bne UserLogoConfigLoopNext

UserLogoConfigLoopRecord:
	iny
	lda sectorBuffer1, y
	cmp #'1'				; if LOGO=1, don't change logo
	beq UserLogoConfigDone
	cmp #'2'				; if LOGO=2, change logo to Simba
	bne +
	lda #$7C				; logo tile difference ($00 = PowerPak, $7C = Simba, $84 = SFC dots)
	sta temp
	lda #$02				; logo palette diff. ($00 = PowerPak, $02 = Simba, $04 = SFC dots)
	sta temp+1
	jump jLoadLogo				; reload logo
	lda #$20				; tile num for "paw" cursor, next is palette
	sta SpriteBuf1+2
	lda #$02				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+3
+
	cmp #'3'				; if LOGO=3, change logo to SFC "four dots"
	bne +
	lda #$84				; logo tile difference ($00 = PowerPak, $7C = Simba, $84 = SFC dots)
	sta temp
	lda #$04				; logo palette diff. ($00 = PowerPak, $02 = Simba, $04 = SFC dots)
	sta temp+1
	jump jLoadLogo				; reload logo
	lda #$22				; tile num for "red dot" cursor, next is palette
	sta SpriteBuf1+2
	lda #$04				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+3
+						; in any other case, don't change logo

UserLogoConfigDone:

rts