;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SD (DEVELOPER'S NOTE) ***
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	sep #$20				; 8 bit Accumulator, 16 bit X/Y
	rep #$10

	lda #$FF				; hide cursor
	sta cursorX
	lda #$F0
	sta cursorY

	lda #$00				; reset input buttons
	sta Joy1New
	sta Joy1New+1
	sta Joy1Press
	sta Joy1Press+1



; **************************** Text page 1 *****************************

Show1stPage:
	jump jPrintClearScreen

 	SetCursorPos 2, 0

	PrintString "Greetings, SNES gamers out there! :-)\n"
	PrintString "\n"
	PrintString "Thank you so much for downloading and installing my un-\n"
	PrintString "official firmware v2.00 for the SNES PowerPak.\n"
	PrintString "\n"
	PrintString "Even as a huge fan of this awesome flash cartridge ever\n"
	PrintString "since it was released in late 2009, I always felt bugged\n"
	PrintString "about its rather flat, quick-and-dirty style menu. Thus,\n"
	PrintString "I finally decided to try and give it a minor redesign\n"
	PrintString "earlier this year.\n"
	PrintString "\n"
	PrintString "Starting off as a simple font hack, this project quickly\n"
	PrintString "evolved into a full-blown GUI overhaul as I discovered\n"
	PrintString "how much more was possible, and necessary. Eventually,\n"
	PrintString "after obtaining The Sourcecode(tm), I was able to pro-\n"
	PrintString "gress ever faster and smoother, the result of which is\n"
	PrintString "finally here for you to enjoy."

	SetCursorPos 21, 4
	PrintString "A: Cont.  -  Start: Return to titlescreen"

	jsr FromMosaic

	lda #$00				; disable mosaic effect
	sta $2106



Page1Loop:
	wai

	lda Joy1New				; check for A button
	and #%10000000
	beq +					; if A is not pressed, check another button
	jsr ToMosaic
	bra Show2ndPage				; ... switch to page 2

+
	lda Joy1Press+1				; check for Start button
	and #%00010000
	beq +					; if Start is not pressed, loop

	jmp ResetSystem				; if Start is pressed, reset to intro

+
	bra Page1Loop



; **************************** Text page 2 *****************************

Show2ndPage:
	jump jPrintClearScreen

 	SetCursorPos 2, 0

	PrintString "Apart from a custom font and three switchable logos,\n"
	PrintString "plus some neat HDMA effects to give things a nicely\n"
	PrintString "polished look, I put the SNES's pseudo hi-res BG mode 5\n"
	PrintString "to good use, which now allows the filebrowser to display\n"
	PrintString "well over 50 characters per entry.\n"
	PrintString "\n"
	PrintString "In case you're wondering, the music playing in the back-\n"
	PrintString "ground was composed and arranged for the SNES by myself.\n"
	PrintString "Can you name all four of the marvelous videogames whose\n"
	PrintString "soundtracks I drew my inspiration from ...?\n"
	PrintString "\n"
	PrintString "Thanks for reading, but now please do start playing! :-)"

	SetCursorPos 16, 2
	PrintString "Long live the SNES PowerPak!"

	SetCursorPos 18, 2
	PrintString "(c) 2012 by www.ManuLoewe.de"

	SetCursorPos 21, 4
	PrintString " A: Back  -  Start: Return to titlescreen"

	jsr FromMosaic

	lda #$00				; disable mosaic effect
	sta $2106



; ************************ PowerPak Logo page 2 ************************

	lda #$9A				; X
	sta SpriteBuf1+16
	lda #$80				; Y
	sta SpriteBuf1+17
	lda #$04				; tile num
	sta SpriteBuf1+18
	lda #$00				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+19

	lda #$BA				; X
	sta SpriteBuf1+20
	lda #$80				; Y
	sta SpriteBuf1+21
	lda #$08				; tile num
	sta SpriteBuf1+22
	lda #$00				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+23

	lda #$9A				; X
	sta SpriteBuf1+24
	lda #$A0				; Y
	sta SpriteBuf1+25
	lda #$44				; tile num
	sta SpriteBuf1+26
	lda #$00				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+27

	lda #$BA				; X
	sta SpriteBuf1+28
	lda #$A0				; Y
	sta SpriteBuf1+29
	lda #$48				; tile num
	sta SpriteBuf1+30
	lda #$00				; vhoopppc Vert Horiz priOrity Palette Charmsb
	sta SpriteBuf1+31

	lda #$AA
	sta SpriteBuf2+1			; 32x32 sprites



Page2Loop:
	wai

	lda Joy1New				; check for A button
	and #%10000000
	beq +					; if A is not pressed, check another button
	lda #$FF
	sta SpriteBuf1+17			; if A is pressed, hide PowerPak logo and switch to page 1
	sta SpriteBuf1+21
	sta SpriteBuf1+25
	sta SpriteBuf1+29
	sta SpriteBuf2+1			; 32x32 sprites
	jsr ToMosaic
	jmp Show1stPage

+
	lda Joy1Press+1				; check for Start button
	and #%00010000
	beq +					; if Start is not pressed, loop

	bra ResetSystem				; if Start is pressed, reset to intro

+
	bra Page2Loop



; ******************************* Reset ********************************

ResetSystem:
	lda #$FF
	sta SpriteBuf1+17			; hide PowerPak logo
	sta SpriteBuf1+21
	sta SpriteBuf1+25
	sta SpriteBuf1+29
	sta SpriteBuf2+1			; 32x32 sprites

	jsr ToMosaic

	lda #%10000001
	sta CONFIGWRITESTATUS			; ... reset PowerPak, stay in boot mode



; **************************** Mosaic stuff ****************************

ToMosaic:
	lda #$03				; enable mosaic on BG1 & BG2,
	sta $2106				; start with smallest block size
-
	wai					; show mosaic for one frame
	clc
	adc #$10				; increase block size by 1
	ora #$03				; repair BG setting
	sta $2106				; update mosaic register
	cmp #$F3				; check if biggest block size reached
	bne -
	wai
rts



FromMosaic:
	lda #$F3				; enable mosaic on BG1 & BG2
	sta $2106				; start with biggest block size
-
	wai					; show mosaic for one frame
	sec
	sbc #$10				; reduce block size by 1
	ora #$03				; repair BG setting
	sta $2106				; update mosaic register
	cmp #$03				; check if smallest block size reached
	bne -
	wai
rts
