;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SB (DISPLAY SRAM FILES) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20				; 8 bit Accumulator, 16 bit X/Y
	REP #$10

	stz Joy1Press
	stz Joy1Press+1
	stz Joy1New
	stz Joy1New+1

	lda #'S'				; SRM extension
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'R'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'M'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

	lda rootDirCluster
	sta sourceCluster
	lda rootDirCluster+1
	sta sourceCluster+1
	lda rootDirCluster+2
	sta sourceCluster+2
	lda rootDirCluster+3
	sta sourceCluster+3

MainLoad:  
	jump jPrintClearScreen
	SetCursorPos 0 0
	jump jCardLoadDir			; root dir
	jump jDirPrintDir



Forever:
	wai
;  SetCursorPos 10 10
;  PrintHexNum cursorY

UpCheck:
	lda Joy1New+1
	and #%00001000
	beq UpDone

UpPressed:
	lda cursorYCounter
	bne UpDone
	lda scrollYCounter
	bne UpDone

UpScroll:
	lda #$08
	sta speedScroll
	lda #$01
	sta speedCounter
	jump jScrollUp

UpDone:



DownCheck:
	lda Joy1New+1
	and #%00000100
	beq DownDone

DownPressed:
	lda cursorYCounter
	bne DownDone
	lda scrollYCounter
	bne DownDone

DownScroll:
	lda #$08
	sta speedScroll
	lda #$01
	sta speedCounter
	jump jScrollDown

DownDone:



LeftCheck:
	lda Joy1Press+1
	and #%00000010
	beq LeftDone

LeftPressed:
	lda cursorYCounter
	bne LeftDone
	lda scrollYCounter
	bne LeftDone

LeftScroll:
	lda #$04
	sta speedScroll
	lda #$02
	sta speedCounter
	jump jScrollUp

LeftDone:



RightCheck:
	lda Joy1Press+1
	and #%00000001
	beq RightDone

RightPressed:
	lda cursorYCounter
	bne RightDone
	lda scrollYCounter
	bne RightDone

RightScroll:
	lda #$04
	sta speedScroll
	lda #$02
	sta speedCounter
	jump jScrollDown

RightDone:



LCheck:
	lda Joy1New
	and #%00100000
	beq LDone

;	jump jPageUp
	jsr PageUp

LDone:



RCheck:
	lda Joy1New
	and #%00010000
	beq RDone

;	jump jPageDown
	jsr PageDown

RDone:



ABXYCheck:
	lda Joy1New+1
	and #%11000000
	bne ABXYNextModule
	lda Joy1New
	and #%11000000
	bne ABXYNextModule			; ABXY = select game
	jmp ABXYCheckDone

ABXYNextModule:
	jsr NextModule

ABXYCheckDone:

;StartCheck:
;  lda Joy1New+1
;  and #%00010000
;  beq StartDone
;  jmp NextModuleSOI     ;;;skip saving the sram info
;StartDone: 

	jmp Forever



NextModule:
	jump jDirGetEntry			; get selected entry

	lda tempEntry.tempDirFlag
	cmp #$01  
	bne NextModuleLoad
	jump jNextDir
rts



NextModuleLoad:
	ldy #$0000

CopyGameNameLoop:
	lda tempEntry, y
	sta saveName, y
	iny
	cpy #$35				; copy 53 chars
	bne CopyGameNameLoop

	stz saveName+$35			; NULL terminate game name

	lda tempEntry.tempCluster
	sta saveName.sCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta saveName.sCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta saveName.sCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta saveName.sCluster+3			; copy to save cluster
	sta sourceCluster+3			; copy to source cluster



NextModuleSOI:
	lda #%00000001
	sta CONFIGWRITESTATUS			; no more battery flag

	jump jClearFindEntry
	lda #'S'
	sta findEntry
	lda nextModule
	sta findEntry+1
	cmp #'I'
	beq NextModuleSI
	jmp NextModuleSOIDone



NextModuleSI:
	lda #$00
	sta DMAWRITELO
	sta DMAWRITEHI
	lda #$F8
	sta DMAWRITEBANK

	lda #$FF				; move cursor off-screen
	sta cursorX
	lda #$F0
	sta cursorY

	jump jPrintClearScreen
	SetCursorPos 14, 6
	PrintString "Saving SRAM file to CF card ..."

	lda #kSourceSDRAM
	sta sourceType

	jump jCardWriteFile

	ClearLine 14
	SetCursorPos 14, 7
	PrintString "SRAM file saved successfully!"

	SetCursorPos 15, 3
	PrintString "Press any button to return to the titlescreen."

-
	lda Joy1New+1				; wait for user input
	and #%11110000				; B, Y, Select, Start (dir. pad excluded)
	bne +
	lda Joy1New+0
	and #%11110000				; A, X, L, R
	bne +
	bra -
+
	lda #$FF
	sta cursorX
	lda #$F0
	sta cursorY
	jump jPrintClearScreen
	jump jLoadLogo
	jump jLoadRomVersion



NextModuleSOIDone:
	jump jCardLoadModule			; load options or save module



; ********************** Page-by-page navigation ***********************

PageDown:
	lda filesInDir+1
	cmp #$00
	bne +
	lda filesInDir
	cmp #$19
	bcs +					; if filesInDir < 25, do nothing
rts

+
	rep #A_8BIT				; A = 16 bit

	lda filesInDir
	sec
	sbc selectedEntry
	cmp #$0031
	bcs +					; if filesInDir-selectedEntry<49, show "last page"
	lda filesInDir				; by means of: selectedEntry=filesInDir-24
	sec
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

	bra ShowNextPage

+
	sep #A_8BIT				; A = 8 bit

	lda cursorY
	sec
	sbc #$18				; subtract indention
	lsr a
	lsr a
	lsr a					; divide by 8 to get selectedEntry difference
	sta temp

	lda selectedEntry
	sec
	sbc temp				; subtract selectedEntry diff. to keep cursor in sync

	rep #A_8BIT				; A = 16 bit

	lda selectedEntry
	clc
	adc #$0018				; add 24 for "next page"
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

ShowNextPage:
	lda #$02				; Y indention
	sta temp

	jump jPrintClearScreen
	SetCursorPos 0, 0

PageDownPrintLoop:				; with these new parameters, print next page
	inc temp				; go to next print line
	jump jDirPrintEntry

 ; jsr DirPrintEntry                            ;copy dir entry to printString
 ; jsr PrintLine                                ;print to name table

	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; increment to next entry index
	adc #$00
	sta selectedEntry+1

	lda temp				; check if printY equal to 26, jump out
	cmp #$1A
	beq PageDownPrintLoopDone

;	lda selectedEntry			; check if temp/temp+1 equal to filesInDir, jump out
;	cmp filesInDir
;	bne PageDownPrintLoop
;	lda selectedEntry+1
;	cmp filesInDir+1
;	bne PageDownPrintLoop

;	lda #$00				; beyond filesInDir, show beginning of directory again
;	sta selectedEntry
;	sta selectedEntry+1

	bra PageDownPrintLoop

PageDownPrintLoopDone:
	rep #A_8BIT

	lda selectedEntry			; since we used the same variable for printing,
	sec					; we must subtract the added 24 lines again
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT

	lda #$18				; #$08 = line 0, #$10 = line 1, etc.
	sta cursorY            
	stz cursorYCounter      
	stz cursorYUp          
	stz cursorYDown          

	stz scrollY            
	stz scrollYCounter      
	stz scrollYUp           
	stz scrollYDown   

	stz speedCounter        
	stz speedScroll         

	lda #$01
	sta insertTop
	lda #$1A
	sta insertBottom

NoPageDown:

rts



PageUp:
	lda filesInDir+1
	cmp #$00
	bne +
	lda filesInDir
	cmp #$19
	bcs +					; if filesInDir < 25, do nothing
rts

+
	lda selectedEntry+1
	cmp #$00
	bne +
	lda selectedEntry
	cmp #$18
	bcs +					; if selectedEntry<=24, show "first page"
	lda #$00
	sta selectedEntry
	sta selectedEntry+1
	bra ShowPrevPage

+
	lda cursorY
	sec
	sbc #$18				; subtract indention
	lsr a
	lsr a
	lsr a					; divide by 8 to get selectedEntry difference
	sta temp

	lda selectedEntry
	sec
	sbc temp				; subtract selectedEntry diff. to keep cursor in sync

	rep #A_8BIT				; A = 16 bit

	lda selectedEntry
	sec
	sbc #$0018				; subtract 24 for "previous page"
	sta selectedEntry

	sep #A_8BIT				; A = 8 bit

ShowPrevPage:
	lda #$02				; Y indention
	sta temp

	jump jPrintClearScreen
	SetCursorPos 0, 0

PageUpPrintLoop:				; with these new parameters, print next page
	inc temp				; go to next print line
	jump jDirPrintEntry

 ; jsr DirPrintEntry                            ;copy dir entry to printString
 ; jsr PrintLine                                ;print to name table

	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; increment to next entry index
	adc #$00
	sta selectedEntry+1

	lda temp				; check if printY equal to 26, jump out
	cmp #$1A
	beq PageUpPrintLoopDone

;	lda selectedEntry			; check if temp/temp+1 equal to filesInDir, jump out
;	cmp filesInDir
;	bne PageUpPrintLoop
;	lda selectedEntry+1
;	cmp filesInDir+1
;	bne PageUpPrintLoop

;	lda #$00				; beyond filesInDir, show beginning of directory again
;	sta selectedEntry
;	sta selectedEntry+1

	bra PageUpPrintLoop

PageUpPrintLoopDone:
	rep #A_8BIT

	lda selectedEntry			; since we used the same variable for printing,
	sec					; we must subtract the added 24 lines again
	sbc #$0018
	sta selectedEntry

	sep #A_8BIT

	lda #$18				; #$08 = line 0, #$10 = line 1, etc.
	sta cursorY            
	stz cursorYCounter      
	stz cursorYUp          
	stz cursorYDown          

	stz scrollY            
	stz scrollYCounter      
	stz scrollYUp           
	stz scrollYDown   

	stz speedCounter        
	stz speedScroll         

	lda #$01
	sta insertTop
	lda #$1A
	sta insertBottom

NoPageUp:

rts
