;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** CF MODULE: SA (AUTO SRAM MATCHING) ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;
;==========================================================================================



; ****************************** Includes ******************************

	.INCLUDE "mapper.inc"			; MemoryMap, VectorTable, HeaderInfo

	.INCLUDE "variables.asm"		; Global Variables



; ******************************** Main ********************************

Main:
	SEP #$20				; 8 bit Accumulator, 16 bit X/Y
	REP #$10

	stz Joy1Press
	stz Joy1Press+1				;reset input buttons  
	stz Joy1New
	stz Joy1New+1

;  lda #$20
;  sta searchEntry
;  sta searchEntry+1
;  sta searchEntry+2
;  sta searchEntry+3
;  sta searchEntry+4
;  sta searchEntry+5
;  sta searchEntry+6
;  sta searchEntry+7

	ldy #$0000

ClearSearchEntry:
	lda #$00
	sta searchEntry, y
	iny
	cpy #$0080				; clear out all 128 chars
	bne ClearSearchEntry

	jump jClearFindEntry

	lda #'S'				; find SAVES dir
	sta findEntry
	lda #'A'
	sta findEntry+1
	lda #'V'
	sta findEntry+2
	lda #'E'
	sta findEntry+3
	lda #'S'
	sta findEntry+4

	jmp SaveDirNameDone



;;;code here down searches the config.txt file instead of the default SAVES dir

	lda #'T'
	sta exMatch1
	sta exMatch1+1
	sta exMatch1+2
	sta exMatch1+3
	lda #'X'
	sta exMatch2
	sta exMatch2+1
	sta exMatch2+2
	sta exMatch2+3
	lda #'T'
	sta exMatch3
	sta exMatch3+1
	sta exMatch3+2
	sta exMatch3+3

;-------------------------------------;

	lda baseDirCluster
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3
	jump jCardLoadDir			; "POWERPAK" dir

	jump jClearFindEntry			; find CONFIG.TXT
	lda #'C'
	sta findEntry  
	lda #'O'
	sta findEntry+1
	lda #'N'
	sta findEntry+2
	lda #'F'
	sta findEntry+3
	lda #'I'
	sta findEntry+4
	lda #'G'
	sta findEntry+5

	jump jDirFindEntry       

	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3			; copy to source cluster

	lda #<sectorBuffer1
	sta destLo
	lda #>sectorBuffer1
	sta destHi				; put into sector RAM
	stz destBank
	stz sectorCounter
	stz bankCounter

	jump jClusterToLBA			; sourceCluster -> first sourceSector

	lda #kDestWRAM
	sta destType

	jump jCardReadSector			; sector -> WRAM

	ldy #$0000

FindS:						; search for "SAVEDIR="
	lda sectorBuffer1, y
	cmp #'S'
	bne FindNext
	lda sectorBuffer1+1, y
	cmp #'A'
	bne FindNext
	lda sectorBuffer1+2, y
	cmp #'V'
	bne FindNext
	lda sectorBuffer1+3, y
	cmp #'E'
	bne FindNext
	lda sectorBuffer1+4, y
	cmp #'D'
	bne FindNext
	lda sectorBuffer1+5, y
	cmp #'I'
	bne FindNext
	lda sectorBuffer1+6, y
	cmp #'R'
	bne FindNext
	lda sectorBuffer1+7, y
	cmp #'='
	bne FindNext
	jmp SaveDirFound

FindNext:
	iny
	cpy #$0100
	bne FindS

SaveDirNotFound:

;;;;;;;;;;;
;  SAVEDIR NOT FOUND in config.txt
;;;;;;;;;;;;

	jmp NextModule



SaveDirFound:
	lda #$20
	sta searchEntry
	sta searchEntry+1
	sta searchEntry+2
	sta searchEntry+3
	sta searchEntry+4
	sta searchEntry+5
	sta searchEntry+6
	sta searchEntry+7

	jump jClearFindEntry

	ldx #$0000

SaveDirName:
	lda sectorBuffer1+8, y
	cmp #$0D				; CR = stop
	beq SaveDirNameDone
	cmp #$0A				; LF = stop
	beq SaveDirNameDone
	cmp #$20				; space = stop
	beq SaveDirNameDone
	cmp #$00				; unknown = stop
	beq SaveDirNameDone
	cmp #$FF				; unknown = stop
	beq SaveDirNameDone

	sta findEntry, x			;store file name char
	iny
	inx
	cpx #$0008				; only store 8 characters
	bne SaveDirName

SaveDirNameDone:



;;;;;;;;;;;
;  SAVEDIR FOUND
;;;;;;;;;;;;

	lda baseDirCluster
	sta sourceCluster
	lda baseDirCluster+1
	sta sourceCluster+1
	lda baseDirCluster+2
	sta sourceCluster+2
	lda baseDirCluster+3
	sta sourceCluster+3

	jump jCardLoadDir			; load "POWERPAK" dir

	jump jDirFindEntry			; save dir into tempEntry

	lda tempEntry.tempCluster
	sta sourceCluster
	lda tempEntry.tempCluster+1
	sta sourceCluster+1
	lda tempEntry.tempCluster+2
	sta sourceCluster+2
	lda tempEntry.tempCluster+3
	sta sourceCluster+3			; transfer save dir cluster

	lda #'S'				; .SRM
	sta exMatch1+0
	sta exMatch1+1    
	sta exMatch1+2     
	sta exMatch1+3    

	lda #'R'
	sta exMatch2+0
	sta exMatch2+1    
	sta exMatch2+2     
	sta exMatch2+3    

	lda #'M'
	sta exMatch3+0
	sta exMatch3+1    
	sta exMatch3+2     
	sta exMatch3+3 
 
	jump jCardLoadDir			; load save dir (.SRM files)


	ldy #$0000

CopyGameName:
	lda gameName, y				; copy the game name to search for
	sta searchEntry, y
	iny
	cpy #$0038				; copy 56 chars
	bne CopyGameName

	jsr DirFindEntryLong			; do the search, back here means entry found

	jump jDirGetEntry			; reload to get full entry name

	ldy #$0000

CopySaveName:
	lda tempEntry, y			; copy the save name we found
	sta saveName, y
	iny
	cpy #$0038				; copy 56 chars
	bne CopySaveName

	lda tempEntry.tempCluster		; copy save cluster
	sta saveName.sCluster
	lda tempEntry.tempCluster+1
	sta saveName.sCluster+1
	lda tempEntry.tempCluster+2
	sta saveName.sCluster+2
	lda tempEntry.tempCluster+3
	sta saveName.sCluster+3

NextModule:
	jump jClearFindEntry
	lda #'S'
	sta findEntry  
	lda #'O'
	sta findEntry+1
	jump jCardLoadModule			; load SO options module



DirFindEntryLong:
	lda #$00
	sta selectedEntry
	sta selectedEntry+1

	lda filesInDir
	bne DirFindEntryLongFiles
	lda filesInDir+1
	bne DirFindEntryLongFiles
	jmp DirFindEntryLongFailed

DirFindEntryLongFiles:
	ldy #$0000

DirFindEntryLongReplaceNes
	lda searchEntry, y
	cmp #'.'
	bne DirFindEntryLongReplaceNesNext
	lda searchEntry+1, y
	cmp #'S'
	beq DirFindEntryLongReplaceNesFound	; found .S
	cmp #'s'
	beq DirFindEntryLongReplaceNesFound	; found .s

	cmp #'G'
	beq DirFindEntryLongReplaceNesFound	; found .G
	cmp #'g'
	beq DirFindEntryLongReplaceNesFound	; found .g

DirFindEntryLongReplaceNesNext:			; go to the next character
	iny
	cpy #$0038				; 56 chars
	bne DirFindEntryLongReplaceNes
	jmp DirFindEntryLongReplaceNesDone

DirFindEntryLongReplaceNesFound:		; found .S or .s, erase it
	lda #$00
	sta searchEntry+1, y			; erase S/s         erase G/g
	iny
	cpy #$0038				; 56 chars
	beq DirFindEntryLongReplaceNesDone	; don't erase past end of file name
	sta searchEntry+1, y			; erase R/r   M/m   erase D/d
	iny
	cpy #$0038				; 56 chars
	beq DirFindEntryLongReplaceNesDone	; don't erase past end of file name
	sta searchEntry+1, y			; erase M/m   C/c   erase 3

DirFindEntryLongReplaceNesDone:



;PrintSearchEntry:
;  ldy #$0000
;PrintSearchEntryLoop:
;  lda searchEntry, y
;  sta printString, y
;  iny
;  cpy #$0020
;  bne PrintSearchEntryLoop
;  
;  lda #$0D
;  sta printY
;  jsr PrintLine



DirFindEntryLongLoop:
	jump jDirGetEntry

	ldy #$0000

DirFindEntryLongReplaceSav			; if .srm is in name, erase it (?? old comment ??)
	lda tempEntry, y
	cmp #'.'
	bne DirFindEntryLongReplaceSavNext
	lda tempEntry+1, y
	cmp #'S'
	beq DirFindEntryLongReplaceFound	; found .S
	cmp #'s'
	beq DirFindEntryLongReplaceFound	; found .s

DirFindEntryLongReplaceSavNext:			; go to the next character
	iny
	cpy #$0038				; 56 chars
	bne DirFindEntryLongReplaceSav
	jmp DirFindEntryLongReplaceSavDone

DirFindEntryLongReplaceFound:			; found .S or .s, erase it
	lda #$00
	sta tempEntry+1, y			; erase the S/s
	iny
	cpy #$0038				; 56 chars
	beq DirFindEntryLongReplaceSavDone	; don't erase past end of file name
	sta tempEntry+1, y			; erase A/a
	iny
	cpy #$0038				; 56 chars
	beq DirFindEntryLongReplaceSavDone	; don't erase past end of file name
	sta tempEntry+1, y			; erase V/v

DirFindEntryLongReplaceSavDone:



DirFindEntryLongCompare:
	ldy #$0000

DirFindEntryLongCharLoop:			; check if entry matches, look at first 53 chars
	lda tempEntry, y
	cmp searchEntry, y
	bne DirFindEntryLongNext
	iny
	cpy #$0035
	bne DirFindEntryLongCharLoop

DirFindEntryLongFound:				; all 53 chars match

rts



DirFindEntryLongNext:
	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; increment to next entry index
	adc #$00
	sta selectedEntry+1

	lda selectedEntry 
	cmp filesInDir
	bne DirFindEntryLongLoop
	lda selectedEntry+1
	cmp filesInDir+1
	bne DirFindEntryLongLoop

DirFindEntryLongFailed:
	jmp NextModule
