@echo off
echo -- COMPILING SNES POWERPAK SOFTWARE --

echo -- compiling SD.MAP --
wla-65816 -oi sd.asm sd.o
wlalink -rsi sd.link sd.sfc
head -c 5120 sd.sfc > out\POWERPAK\SD.MAP

echo -- compiling SN.MAP --
wla-65816 -oi sn.asm sn.o
wlalink -rsi sn.link sn.sfc
head -c 5120 sn.sfc > out\POWERPAK\SN.MAP

echo -- compiling SI.MAP --
wla-65816 -oi si.asm si.o
wlalink -rsi si.link si.sfc
head -c 5120 si.sfc > out\POWERPAK\SI.MAP 

echo -- compiling SO.MAP --
wla-65816 -oi so.asm so.o
wlalink -rsi so.link so.sfc
head -c 5120 so.sfc > out\POWERPAK\SO.MAP 

echo -- compiling SB.MAP --
wla-65816 -oi sb.asm sb.o
wlalink -rsi sb.link sb.sfc
head -c 5120 sb.sfc > out\POWERPAK\SB.MAP 

echo -- compiling SQ.MAP --
wla-65816 -oi sq.asm sq.o
wlalink -rsi sq.link sq.sfc
head -c 5120 sq.sfc > out\POWERPAK\SQ.MAP 

echo -- compiling SM.MAP --
wla-65816 -oi sm.asm sm.o
wlalink -rsi sm.link sm.sfc
head -c 5120 sm.sfc > out\POWERPAK\SM.MAP 

echo -- compiling SG.MAP --
wla-65816 -oi sg.asm sg.o
wlalink -rsi sg.link sg.sfc
head -c 5120 sg.sfc > out\POWERPAK\SG.MAP 

echo -- compiling SP.MAP --
wla-65816 -oi sp.asm sp.o
wlalink -rsi sp.link sp.sfc
head -c 5120 sp.sfc > out\POWERPAK\SP.MAP 

echo -- compiling SA.MAP --
wla-65816 -oi sa.asm sa.o
wlalink -rsi sa.link sa.sfc
head -c 5120 sa.sfc > out\POWERPAK\SA.MAP 

echo -- generating LOG.TXT --
zerofill -f -q 0x800 out\POWERPAK\LOG.TXT

echo -- generating LASTSNES.TXT --
zerofill -f -q 0x200 out\POWERPAK\LASTSNES.TXT

echo -- generating CONFIG.TXT --
echo DMA=1 > out\POWERPAK\CONFIG.TXT
echo LOGO=1 >> out\POWERPAK\CONFIG.TXT

echo -- copying TOPLEVEL.BIT --
copy TOPLEVEL.BIT out\POWERPAK\TOPLEVEL.BIT

echo -- copying SD.SPC --
copy music\zeldariokoden.spc out\POWERPAK\SD.SPC

echo -- compiling LOADER.BIN --
wla-65816 -oi loader.asm loader.o
wlalink -rsi loader.link loader.sfc
snestools -hi! -hc loader.sfc
copy loader.sfc out\loader.bin
del loader.o

echo -- FINISHED! --

pause
