;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** PRINT HANDLER ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;	- Neviksti (subroutines ??), (c) 2002
;
;==========================================================================================



;.BANK 0 SLOT 0
;.SECTION "Print_Handler"

;Print -- Print an ASCII character to the BG3 buffer
;	    which needs to be copied into VRAM in the NMI handler.
;         Of course, an 8x8 ASCII tile set must
;         be loaded and the VRAM pointer set ahead of time
;In: A -- ASCII code to print
;Out: none
;Modifies: P



Print_BG2:
	PHX					; expectations: A/Mem=8bit, X/Y=16bit

	LDX Cursor
	ASL					; character code * 2 so it matches hi-res font tile location
	STA TxtBuf2bpp, X			; put character to the text buffer
;	INX					; commented out because cursor has to retain position
	STX Cursor				; needed ??

	PLX
RTS



Print_BG1:
	PHX

	LDX Cursor
	ASL					; character code * 2 so it matches hi-res font tile location
	STA TxtBuf4bpp, X			; put character to the text buffer
	INX					; cursor position + 1
	STX Cursor

	PLX
RTS



;PrintF -- Print a Formatted, NULL terminated string to Stdout
;In:   X -- points to format string
;      Y -- points to parameter buffer
;Out: none
;Modifies: none
;Notes:
;     Supported Format characters:
;       %s -- sub-string (reads 16-bit pointer from Y data)
;       %d -- 16-bit Integer (reads 16-bit data from Y data)
;       %b -- 8-bit Integer (reads 8-bit data from Y data)
;       %x -- 8-bit hex Integer (reads 8-bit data from Y data)
;       %% -- normal %
;       \n -- Newline
;       \t -- Tab
;       \b -- Page break
;       \\ -- normal slash
;     String pointers all refer to current Data Bank (DB)

PrintFJump:
	ldx strPtr2

PrintF:						; assumes 8b mem, 16b index
	PHP
	PHA
	PHX
	PHY

	rep #$10				; A/mem=8bit, X/Y=16bit
	sep #$20

PrintFLoop:
	LDA $0000,X				; read next format string character
	BEQ PrintFDone				; check for NULL terminator
	INX					; increment input pointer
	CMP #'%'
	BEQ PrintFFormat			; handle format character
	CMP #'\'
	BEQ PrintFControl			; handle control character

NormalPrint:
	JSR Print_BG2				; print the character on BG2 (via buffer)
	LDA $0000,X				; read next format string character
	BEQ PrintFDone				; check for NULL terminator
	INX					; increment input pointer
	CMP #'%'
	BEQ PrintFFormat			; handle format character
	CMP #'\'
	BEQ PrintFControl			; handle control character
	JSR Print_BG1				; print the character on BG1 (via buffer)
	BRA PrintFLoop

PrintFDone:
	PLY
	PLX
	PLA
	PLP
RTS



PrintFControl:
	LDA $0000,X				; read control character
	BEQ PrintFDone				; check for NULL terminator
	INX					; increment input pointer
	CMP #'n'
_cn:  BNE _ct
	rep #$30				; 16b mem, 16b X
	LDA Cursor				; get current position
	CLC
	ADC #$0020				; move to the next line
	AND #$FFE0
	ORA #$0002				; adds horizontal indention by 2 tiles
	STA Cursor				; save new position
	sep #$20				; 8b mem, 16b X
	BRA PrintFLoop
_ct:	CMP #'t'
	BNE _cb
	rep #$30				; 16b mem, 16b X
	LDA Cursor				; get current position
	CLC
	ADC #$0008				; move to the next tab
	AND #$FFF8
	STA Cursor				; save new position
	sep #$20				; 8b mem, 16b X
	BRA PrintFLoop
_cb:	CMP #'b'
	BNE _defaultC
	STZ Cursor				; page break
	STZ Cursor+1
	BRA NormalPrint
_defaultC:
	LDA #'\'				; normal backslash
	BRA NormalPrint

PrintFFormat:
	LDA $0000,X				; read format character
	BEQ PrintFDone				; check for NULL terminator
	INX					; increment input pointer
_sf:	CMP #'s'
	BNE _df
	PHX					; preserve current format string pointer
	LDX 0,Y					; load sub-string pointer
	INY
	INY
	JSR PrintF				; call PrintF recursively with sub-string
	PLX
	BRA PrintFLoop
_df:	CMP #'d'
	BNE _bf
	JSR PrintInt16				; print 16-bit integer
	JMP PrintFLoop
_bf:	CMP #'b'
	BNE _xf
	JSR PrintInt8				; print 8-bit integer
	JMP PrintFLoop
_xf:	CMP #'x'
	BNE _defaultF
	JSR PrintHex8				; print 8-bit hex integer
	JMP PrintFLoop
_defaultF:
	LDA #'%'
	JMP NormalPrint



;PrintInt16 -- Read a 16-bit value pointed to by Y and print it to stdout
;In:  Y -- Points to integer in current data bank
;Out: Y=Y+2
;Modifies: P
;Notes: Uses Print to output ASCII to stdout

PrintInt16:					; assumes 8b mem, 16b index
	LDA #$00
	PHA					; push $00
	LDA $0000,Y
	STA $4204				; DIVC.l
	LDA $0001,Y
	STA $4205				; DIVC.h  ... DIVC = [Y]
	INY
	INY

DivLoop:
	LDA #$0A	
	STA $4206				; DIVB = 10 --- division starts here (need to wait 16 cycles)
	NOP					; 2 cycles
	NOP					; 2 cycles
	NOP					; 2 cycles
	PHA					; 3 cycles
	PLA					; 4 cycles
	LDA #'0'				; 2 cycles
	CLC					; 2 cycles
	ADC $4216				; A = '0' + DIVC % DIVB
	PHA					; push character
	LDA $4214				; Result.l -> DIVC.l
	STA $4204
	BEQ _Low_0
	LDA $4215				; Result.h -> DIVC.h
	STA $4205
	BRA DivLoop

_Low_0:
	LDA $4215				; Result.h -> DIVC.h
	STA $4205
	BEQ IntPrintLoop			; if ((Result.l==$00) and (Result.h==$00)) then we're done, so print
	BRA DivLoop

IntPrintLoop:					; until we get to the end of the string...
	PLA					; keep pulling characters and printing them
	BEQ _EndOfInt
	JSR Print_BG1				; print them to the BG1 buffer // FIXME2.0 if possible
	BRA IntPrintLoop

_EndOfInt:

RTS



;PrintInt8 -- Read an 8-bit value pointed to by Y and print it to stdout
;In:  Y -- Points to integer in current data bank
;Out: Y=Y+1
;Modifies: P
;Notes: Uses Print to output ASCII to stdout

PrintInt8:					; assumes 8b mem, 16b index
	LDA $0000,Y
	INY

PrintInt8_noload:
	STA $4204
	LDA #$00
	STA $4205
	PHA
	BRA DivLoop

PrintInt16_noload:				; assumes 8b mem, 16b index
	LDA #$00
	PHA					; push $00
	STX $4204				;DIVC = X
	JSR DivLoop



;PrintHex8 -- Read an 8-bit value pointed to by Y and print it in hex to stdout
;In:  Y -- Points to integer in current data bank
;Out: Y=Y+1
;Modifies: P
;Notes: Uses Print to output ASCII to stdout

PrintHex8:					; assumes 8b mem, 16b index
	lda $0000,Y
	iny

PrintHex8_noload:
	pha
	lsr A
	lsr A
	lsr A
	lsr A
	jsr PrintHexNibble
	pla
	and #$0F
	jsr PrintHexNibble
rts	

PrintHexNibble:					; assumes 8b mem, 16b index
	cmp #$0A
	bcs _nletter
	clc
	adc #'0'
	jsr Print_BG1				; print it to the BG1 buffer // FIXME2.0 if possible
rts

_nletter: 	
	clc
	adc #'A'-10		
	jsr Print_BG1				; print it to the BG1 buffer // FIXME2.0 if possible
rts



PrintClearLine:					; Reminder: The clear line string must not exceed 62 bytes,
	pha					; but shouldn't fall below 60 spaces either!
	asl a
	asl a
	asl a
	asl a
	asl a
	sta Cursor
	pla
	lsr a
	lsr a
	lsr a
	sta Cursor+1
	PrintString "                                                            "
rts



PrintClearScreen:
	ldx #$0000
	lda #$40				; = asl #$20 (space's ASCII code)

PrintClearScreenLoop:
	sta TxtBuf2bpp, x			; clear BG2 text buffer
	sta TxtBuf4bpp, x			; clear BG1 text buffer, too
	inx
	cpx #$0400
	bne PrintClearScreenLoop
rts



;.ENDS
