;==========================================================================================
;
;   UNOFFICIAL SNES POWERPAK FIRMWARE V2.00-BETA1 (CODENAMED "SIMBA")
;   (c) 2012 by ManuLwe (http://www.manuloewe.de/)
;
;	*** VIDEO SETUP & NMI HANDLER ***
;	Code in this file based on v1.0X code written by:
;	- bunnyboy (SNES PowerPak creator), (c) 2009
;	- Neviksti (subroutines ??), (c) 2002
;
;==========================================================================================



.BANK 0 SLOT 0
.ORG HEADER_OFF
.SECTION "QuickCodeSection" SEMIFREE



VBlank:
	pha
	phx
	phy					; make sure to store all registers
	phb					; before you run your IRQ routine
	php					; and pull them back after you're done
	phk					; so when it returns it will not have screwed
	plb					; up anything!


	sep #$20				; mem/A = 8 bit, X/Y = 16 bit
	rep #$10


	jump jDoScrolling



; ************************* Move cursor sprite *************************

	lda cursorX
	sta SpriteBuf1
	lda cursorY
	sec
	sbc #$10
	; clc
	; adc #$08
	sta SpriteBuf1+1



; ************************ Transfer sprite data ************************

	stz $2102				; set OAM address to 0
	stz $2103

	LDY #$0400				; CPU -> PPU, auto increment, write 1 reg, $2104 (OAM data write)
	STY $4300
	LDY #SpriteBuf1				; source offset
	STY $4302
	LDY #$0220				; number of bytes to transfer
	STY $4305
	LDA #$00
	STA $4304				; bank address = $7E  (we're in lower 8K of WRAM)
	LDA #$01
	STA $420B				; start DMA transfer channel 0



; ************************* Transfer BG2 data **************************

	LDA #$00
	STA $2115				; set up VRAM write to write only the lower byte

	LDX #$0400
	STX $2116				;set VRAM address to BG2 tile map

	LDY #$1800				; CPU -> PPU, auto increment, write 1 reg, $2118 (Lowbyte of VRAM write)
	STY $4300
	LDY #TxtBuf2bpp-$7F0000			; source offset / without subtraction, WLA DX will complain
	STY $4302
	LDY #$0400				; number of bytes to transfer
	STY $4305
	LDA #$7F				; bank address = $7F (used to be in the lower 8k of WRAM)
	STA $4304
	LDA #$01
	STA $420B				; start DMA transfer channel 0



; ************************* Transfer BG1 data **************************

	LDA #$00
	STA $2115				; set up VRAM write to write only the lower byte

	LDX #$0800
	STX $2116				; set VRAM address to BG1 tile map

	LDY #$1800				; CPU -> PPU, auto increment, write 1 reg, $2118 (Lowbyte of VRAM write)
	STY $4300
	LDY #TxtBuf4bpp-$7F0000			; source offset / without subtraction, WLA DX will complain
	STY $4302
	LDY #$0400				; number of bytes to transfer
	STY $4305
	LDA #$7F				; bank address = $7F
	STA $4304
	LDA #$01
	STA $420B				; start DMA transfer channel 0



; ***************************** HDMA setup *****************************

	stz $420C				; turn off HDMA
	jsr SetupHDMA				; set up HDMA transfers on channels 5, 6, and 7
	lda #%11100000
	sta $420C				; activate HDMA channels


; ************************* Update joypad data *************************

	JSR GetInput



; ******************** Scrolling, misc., end VBLANK ********************

	lda scrollY

	sta $210E				; BG1 vertical scroll
	stz $210E

	; lda scrollX+1				; Scroll BG3 vertical (?? old comment ??)

	sta $2110				; BG2 vertical scroll
	stz $2110

	lda $4210				; clear NMI Flag

	REP #$30				; A/Mem=16bits, X/Y=16bits

	inc FrameNum

	plp					; pull original registers back!
	plb
	ply
	plx
	pla

RTI

; **********************************************************************



QuickSetup:

	php

	rep #$10				; A/mem = 8bit, X/Y=16bit
	sep #$20



; ********************* Load palette & tile data ***********************

	LoadPalette BG_Palette

	LoadBlockToVRAM	Font2bpp, $2000, $1000	; address = $2000, size = $1000

	LoadBlockToVRAM	Font4bpp, $4000, $2000	; address = $4000, 4bpp font size = 2 * 2bpp font size

	LoadBlockToVRAM	SpriteTiles, $6000, $2000	; 16 32x32 tiles * (4bit color = 4 planes) --> 8192 bytes

; Set the priority bit of all the BG2 tiles
	LDA #$80
	STA $2115				; set up the VRAM so we can write just to the high byte
	LDX #$0400
	STX $2116
	LDX #$0400				; set BG2's tilemap size (32x32 tiles = 1024)
	LDA #$20				; set priority bit
__next_tile_BG2:
	STA $2119				; ... and stuff it into VRAM
	DEX
	BNE __next_tile_BG2
	LDX #$0800				; set VRAM address (lower 8 bit) $800 for BG1
	STX $2116
	LDX #$0400				; set BG1's tilemap size (same as before)
	LDA #$20				; set priority bit
__next_tile_BG1:
	STA $2119				; ... and shove it into VRAM
	DEX
	BNE __next_tile_BG1



; ******************** Set up and enable the screen ********************

	; lda #$A3				; Sprites 32x32 or 64x64, character data at $6000 (word address)
	lda #%01100011				; 16x16 sprites
	sta $2101


	lda #$05				; set video mode 5 for high resolution :-)
	sta $2105

	lda #$08				; tell SetINI display control register, too (needed?)
	sta $2133

	lda #$08				; set BG1's Tile Map VRAM offset to $0800 (word address)
	sta $2107				; and the Tile Map size to 32 tiles x 32 tiles

	lda #$04				; set BG2's Tile Map VRAM offset to $0400 (word address)
	sta $2108				; and the Tile Map size to 32 tiles x 32 tiles

	lda #$24				; set BG1's Character VRAM offset to $4000 (word address)
	sta $210B				; set BG2's Character VRAM offset to $2000 (word address)

	lda #%00010011				; turn on BG1 + BG2 + sprites
	sta $212C				; on the mainscreen
	sta $212D				; and on the subscreen

	lda #$FF				; scroll BG1 down 1 pixel
	sta $210E
	stz $210E

	; lda scrollX+1

	sta $2110				; scroll BG2 down, too
	stz $2110

	stz $210D				; no BG1 horizontal scroll
	stz $210D

	stz $210F				; no BG2 horizontal scroll
	stz $210F

	lda #%00100010				; enable window 1 on BG1 & BG2
	sta $2123				; (this is necessary to cut off some garbage lines in the filebrowser)
	lda #$00
	sta $2126				; set window 1 left position (0)
	lda #$FF
	sta $2127				; set window 1 right position (255), window fills the whole screen
	lda #%00000011				; disable window content on BG1 & BG2 (re-enabled via HDMA)
	sta $212E				; on mainscreen
	sta $212F				; and subscreen

	lda #%00110000				; Nintendo's official SNES dev manual recommends setting bits 4 and 5
	sta $2130				; of the color math control register when using BG mode 5 (p. 2-19-1)

	lda #$0F				; "MAIN SCREEN TURN ON!!" :-)
	sta $2100

	plp
rts



; ************************* Scrolling routine **************************

DoScrolling:

CheckCursor:
	;check cursor counter, no scroll if counter=0
	lda cursorYCounter
	cmp #$00
	beq CursorDone
	dec cursorYCounter
	;scroll = scroll + scrollUp - scrollDown

CursorScroll:
	lda cursorY
	sec
	sbc cursorYUp
	clc
	adc cursorYDown
	sta cursorY

CursorDone:

CheckYScroll:
	lda scrollYCounter			; check scroll counter, no scroll if counter=0
	beq DoYScrollDone
	dec scrollYCounter

DoYScroll:					; scroll = scroll - scrollUp + scrollDown
	lda scrollY
	sec
	sbc scrollYUp
	clc
	adc scrollYDown
	sta scrollY
;	cmp #$F0 ; 240
;	bcc	DoYScrollDone  ; scrollY < 240, no underflow/overflow
;DoYScrollOverflow:
;	cmp	#$F8	; 248
;	bcs	DoYScrollUnderflow  ; scrollY > 248, no overflow
;	sec
;	sbc	#$F0	; scroll = scroll - 240
;	sta	scrollY
;	jmp	DoYScrollDone
;DoYScrollUnderflow:
;	lda scrollY
;	sec
;	sbc	#$10
;	sta	scrollY

DoYScrollDone:

rts



ScrollUp:
	sec
	lda selectedEntry
	sbc #$01
	sta selectedEntry
	lda selectedEntry+1			; go to prev entry
	sbc #$00
	sta selectedEntry+1

	lda selectedEntry
	cmp #$FF
	bne ScrollUpCheckTop
	lda selectedEntry+1
	cmp #$FF
	bne ScrollUpCheckTop			; check if selectedEntry = FFFF (underflow)

	lda filesInDir
	sta selectedEntry
	lda filesInDir+1
	sta selectedEntry+1			; underflow, reset selectedEntry = filesInDir-1
	sec
	lda selectedEntry
	sbc #$01
	sta selectedEntry
	lda selectedEntry+1
	sbc #$00
	sta selectedEntry+1

	lda filesInDir+1
	cmp #$00
	bne ScrollUpCheckTop
	lda filesInDir
	cmp #$19
	bcs ScrollUpCheckTop			; check if filesInDir > 25 (cursor is restricted to 24)

	lda filesInDir
	asl a
	asl a
	asl a					; multiply by 8 for sprite height
	clc
	adc #$18				; indent
	sta cursorY				; put cursor at bottom of list
	jmp ScrollUpCheckMiddle

ScrollUpCheckTop:
	lda cursorY
	cmp #$18				; indent
	bne ScrollUpCheckMiddle			; check if cursor at top

	lda speedCounter
	sta scrollYCounter			; cursor at top, scroll background, leave cursor
	lda speedScroll
	sta scrollYUp
	lda #$00
	sta scrollYDown


	lda insertTop
	sta temp
	jump jPrintClearLine
	lda temp
	asl a
	asl a
	asl a
	asl a
	asl a
	ora #$02				; indent
	sta Cursor
	lda temp
	lsr a
	lsr a
	lsr a
	sta Cursor+1
	jump jDirPrintEntry

	lda insertBottom
	sec
	sbc #$01
	and #%00011111
	sta insertBottom
	lda insertTop
	sec
	sbc #$01
	and #%00011111
	sta insertTop

	jmp ScrollUpDone

ScrollUpCheckMiddle:
	lda speedCounter
	sta cursorYCounter
	lda speedScroll
	sta cursorYUp
	lda #$00
	sta cursorYDown

ScrollUpDone:

rts



ScrollDown:
	clc
	lda selectedEntry
	adc #$01
	sta selectedEntry
	lda selectedEntry+1			; go to next entry
	adc #$00
	sta selectedEntry+1

	lda selectedEntry
	cmp filesInDir
	bne ScrollDownCheckBottom
	lda selectedEntry+1
	cmp filesInDir+1
	bne ScrollDownCheckBottom		; check if selectedEntry = filesInDir

	lda #$00
	sta selectedEntry
	sta selectedEntry+1			; overflow, reset to 0

	lda filesInDir+1
	cmp #$00
	bne ScrollDownCheckBottom
	lda filesInDir
	cmp #$19
	bcs ScrollDownCheckBottom		; check if filesInDir > 25

	lda #$10
	sta cursorY				; put cursor at top of screen (it "scrolls in" from one line above)
	jmp ScrollDownCheckMiddle

ScrollDownCheckBottom:
	lda cursorY
	cmp #$D0				; #$D0 = scanline 208
	bne ScrollDownCheckMiddle		; check if cursor at bottom

	lda speedCounter			; cursor at bottom, move background, leave cursor
	sta scrollYCounter			; set scrollYCounter (8 or 4)
	lda speedScroll
	sta scrollYDown				; set scrollYDown to speed (1 or 2)
	lda #$00
	sta scrollYUp

ScrollDownCheckBottomDone:
	lda insertBottom
	sta temp
	jump jPrintClearLine
	lda temp
	asl a
	asl a
	asl a
	asl a
	asl a
	ora #$02				; indent
	sta Cursor
	lda temp
	lsr a
	lsr a
	lsr a
	sta Cursor+1

	jump jDirPrintEntry

	lda insertBottom
	clc
	adc #$01
	and #%00011111
	sta insertBottom
	lda insertTop
	clc
	adc #$01
	and #%00011111
	sta insertTop

	jmp ScrollDownDone

ScrollDownCheckMiddle:
	lda speedCounter
	sta cursorYCounter
	lda speedScroll
	sta cursorYDown
	lda #$00
	sta cursorYUp

ScrollDownDone:

rts



; ************************** HDMA parameters ***************************

SetupHDMA:
	ldx #HDMATableColor			; channel 5: color gradient
	stx $4352
	lda #HDMATableColor>>16
	sta $4354
	lda #$21				; PPU register $2121 (color index)
	sta $4351
	lda #$03
	sta $4350

	ldx #HDMATableMain			; channel 6: mainscreen window
	stx $4362
	lda #$00
	sta $4364
	lda #$2E				; PPU reg. $212E (enable/disable mainscreen BG window area)
	sta $4361
	lda #$00
	sta $4360

	ldx #HDMATableSub			; channel 7: subscreen window
	stx $4372
	lda #$00
	sta $4374
	lda #$2F				; PPU reg. $212F (enable/disable subscreen BG window area)
	sta $4371
	lda #$00
	sta $4370
rts



; **************************** HDMA tables *****************************

; HDMA table for mainscreen window
HDMATableMain:
	.db $0F,$03				; set mainscreen window = $03 (disabled), skip to scanline 15
	.db $7F,$00				; set mainscreen window = $00 (enabled), skip to scanline 127+15=142
	.db $41,$00				; set mainscreen window = $00 (enabled), skip to scanline 142+65=207
	.db $01,$03				; set mainscreen window = $03 (disabled)
	.db $00

; HDMA table for subscreen window
HDMATableSub:
	.db $0F,$03				; set subscreen window = $03 (disabled), skip to scanline 15
	.db $7F,$00				; set subscreen window = $00 (enabled), skip to scanline 127+15=142
	.db $41,$00				; set subscreen window = $00 (enabled), skip to scanline 142+65=207
	.db $01,$03				; set subscreen window = $03 (disabled)
	.db $00

; HDMA table for backdrop color gradient
HDMATableColor:					; made with Ersanio's HDMA Gradient Ripper v1.2.2 :-)
	.db $5A
	.dw $0000,$2C00
	.db $0D
	.dw $0000,$2800
	.db $0D
	.dw $0000,$2400
	.db $0D
	.dw $0000,$2000
	.db $0D
	.dw $0000,$1C00
	.db $0E
	.dw $0000,$1800
	.db $0B
	.dw $0000,$1400
	.db $0E
	.dw $0000,$1000
	.db $0D
	.dw $0000,$0C00
	.db $0C
	.dw $0000,$0800
	.db $0E
	.dw $0000,$0400
	.db $04
	.dw $0000,$0000
	.db $00

; **********************************************************************



.ENDS



;==========================================================================================



.BANK 1 SLOT 0
.ORG 0
.SECTION "CharacterData"



; *************** Fonts, sprites, and palette BIN files ****************

BG_Palette:
	;.REPT 128
	;.DW 0
	;.ENDR
	.INCBIN ".\\gfx\\fonts.clr"		; font palettes
	.INCBIN ".\\gfx\\sprites.clr"		; sprite palettes
						; palette at $00 = new PowerPak logo
						; palette at $20 = Simba logo + "paw" cursor
						; palette at $40 = SFC "four dots" logo + "red dot" cursor
						; palette at $60 = original arrow-style cursor

Font2bpp:
	.INCBIN ".\\gfx\\font_2bpp.bin"		; 2bpp font for BG2

Font4bpp:
	.INCBIN ".\\gfx\\font_4bpp.bin"		; 4bpp font for BG1

SpriteTiles:
	.INCBIN ".\\gfx\\sprites.bin"		; sprites

; **********************************************************************



.ENDS



;==========================================================================================
